/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.auth;

import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.ParameterAlphaComparator;
import com.aetrion.flickr.RequestContext;
import com.aetrion.flickr.util.ByteUtilities;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AuthUtilities {
    public static String getSignature(List parameters) {
        RequestContext requestContext = RequestContext.getRequestContext();
        return AuthUtilities.getSignature(requestContext.getSharedSecret(), parameters);
    }

    public static String getMultipartSignature(List parameters) {
        RequestContext requestContext = RequestContext.getRequestContext();
        return AuthUtilities.getMultipartSignature(requestContext.getSharedSecret(), parameters);
    }

    public static String getSignature(String sharedSecret, List params) {
        AuthUtilities.addAuthToken(params);
        StringBuffer buffer = new StringBuffer();
        buffer.append(sharedSecret);
        Collections.sort(params, new ParameterAlphaComparator());
        for (Parameter param : params) {
            buffer.append(param.getName());
            buffer.append(param.getValue());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return ByteUtilities.toHexString(md.digest(buffer.toString().getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }

    public static String getMultipartSignature(String sharedSecret, List params) {
        ArrayList<String> ignoreParameters = new ArrayList<String>();
        ignoreParameters.add("photo");
        AuthUtilities.addAuthToken(params);
        StringBuffer buffer = new StringBuffer();
        buffer.append(sharedSecret);
        Collections.sort(params, new ParameterAlphaComparator());
        for (Parameter param : params) {
            if (ignoreParameters.contains(param.getName().toLowerCase())) continue;
            buffer.append(param.getName());
            buffer.append(param.getValue());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return ByteUtilities.toHexString(md.digest(buffer.toString().getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }

    public static void addAuthToken(List params) {
        String authToken;
        Iterator it = params.iterator();
        boolean tokenFlag = false;
        while (it.hasNext()) {
            if (!((Parameter)it.next()).getName().equals("auth_token")) continue;
            tokenFlag = true;
        }
        if (!tokenFlag && RequestContext.getRequestContext().getAuth() != null && (authToken = RequestContext.getRequestContext().getAuth().getToken()) != null && !authToken.equals("")) {
            params.add(new Parameter("auth_token", authToken));
        }
    }

    public static boolean isAuthenticated(List params) {
        String authToken;
        Iterator it = params.iterator();
        boolean tokenFlag = false;
        while (it.hasNext()) {
            if (!((Parameter)it.next()).getName().equals("auth_token")) continue;
            tokenFlag = true;
        }
        if (!tokenFlag && RequestContext.getRequestContext().getAuth() != null && (authToken = RequestContext.getRequestContext().getAuth().getToken()) != null && !authToken.equals("")) {
            tokenFlag = true;
        }
        return tokenFlag;
    }
}

