/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.collections;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import com.aetrion.flickr.collections.CollectionsSearchParameters;
import com.aetrion.flickr.collections.PhotoCollection;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CollectionsInterface {
    private static final long serialVersionUID = 12L;
    public static final String METHOD_GET_TREE = "flickr.collections.getTree";
    private String apiKey;
    private String sharedSecret;
    private Transport transport;

    public CollectionsInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = transport;
    }

    public PhotoCollection getTree(CollectionsSearchParameters params) throws IOException, SAXException, FlickrException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_GET_TREE));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.addAll(params.getAsParameters());
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        String path = this.transport.getPath();
        Response response = this.transport.get(path, parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element collectionsElement = response.getPayload();
        PhotoCollection collection = new PhotoCollection(collectionsElement);
        return collection;
    }
}

