/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.collections;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photosets.Photoset;
import com.aetrion.flickr.photosets.PhotosetsInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PhotoCollection {
    private List<PhotoCollection> subPhotoCollection = new ArrayList<PhotoCollection>();
    private List<Photoset> subPhotoset = new ArrayList<Photoset>();

    public PhotoCollection(Node collectionNode) {
        NodeList allNodes = collectionNode.getChildNodes();
        int childIndex = 0;
        while (childIndex < allNodes.getLength()) {
            Node node = allNodes.item(childIndex);
            if (node.getNodeName() == "collection") {
                this.subPhotoCollection.add(new PhotoCollection(node));
            } else if (node.getNodeName() == "set") {
                NamedNodeMap attrs = node.getAttributes();
                Photoset set = new Photoset();
                int j = 0;
                while (j < attrs.getLength()) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName() == "title") {
                        set.setTitle(attr.getNodeValue());
                    } else if (attr.getNodeName() == "description") {
                        set.setDescription(attr.getNodeValue());
                    } else if (attr.getNodeName() == "id") {
                        set.setId(attr.getNodeValue());
                    }
                    ++j;
                }
                this.subPhotoset.add(set);
            }
            ++childIndex;
        }
    }

    public PhotoList getPhotoUrls(PhotosetsInterface inter) throws FlickrException, IOException, SAXException {
        PhotoList allList = null;
        for (Photoset set : this.getAllPhotosets()) {
            Photoset infoSet = inter.getInfo(set.getId());
            PhotoList list = inter.getPhotos(infoSet.getId(), infoSet.getPhotoCount(), 0);
            if (allList == null) {
                allList = list;
                continue;
            }
            for (Object o : list) {
                Photo p = (Photo)o;
                allList.add(p);
            }
            allList.setTotal(allList.size());
        }
        return allList;
    }

    private List<Photoset> getAllPhotosets() {
        return this.getAllPhotosets(new ArrayList<Photoset>());
    }

    private List<Photoset> getAllPhotosets(ArrayList<Photoset> arrayList) {
        for (PhotoCollection col : this.subPhotoCollection) {
            col.getAllPhotosets(arrayList);
        }
        for (Photoset set : this.subPhotoset) {
            arrayList.add(set);
        }
        return arrayList;
    }
}

