/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.commons;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.commons.Institution;
import com.aetrion.flickr.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommonsInterface {
    public static final String METHOD_GET_INSTITUTIONS = "flickr.commons.getInstitutions";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public CommonsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public ArrayList getInstitutions() throws FlickrException, IOException, SAXException {
        ArrayList<Institution> institutions = new ArrayList<Institution>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_GET_INSTITUTIONS));
        parameters.add(new Parameter("api_key", this.apiKey));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element mElement = response.getPayload();
        NodeList mNodes = mElement.getElementsByTagName("institution");
        int i = 0;
        while (i < mNodes.getLength()) {
            Element element = (Element)mNodes.item(i);
            institutions.add(this.parseInstitution(element));
            ++i;
        }
        return institutions;
    }

    private Institution parseInstitution(Element mElement) {
        Institution inst = new Institution();
        inst.setId(mElement.getAttribute("nsid"));
        inst.setDateLaunch(mElement.getAttribute("date_launch"));
        inst.setName(XMLUtilities.getChildValue(mElement, "name"));
        Element urlsElement = (Element)mElement.getElementsByTagName("urlss").item(0);
        NodeList urlNodes = mElement.getElementsByTagName("url");
        int i = 0;
        while (i < urlNodes.getLength()) {
            Element urlElement = (Element)urlNodes.item(i);
            if (urlElement.getAttribute("type").equals("site")) {
                inst.setSiteUrl(XMLUtilities.getValue(urlElement));
            } else if (urlElement.getAttribute("type").equals("license")) {
                inst.setLicenseUrl(XMLUtilities.getValue(urlElement));
            } else if (urlElement.getAttribute("type").equals("flickr")) {
                inst.setFlickrUrl(XMLUtilities.getValue(urlElement));
            }
            ++i;
        }
        return inst;
    }
}

