/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.galleries;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import com.aetrion.flickr.galleries.SearchParameters;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photos.PhotoUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GalleriesInterface {
    private static final long serialVersionUID = 12L;
    public static final String METHOD_GET_PHOTOS = "flickr.galleries.getPhotos";
    private String apiKey;
    private String sharedSecret;
    private Transport transport;

    public GalleriesInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = transport;
    }

    public PhotoList getPhotos(SearchParameters params, int perPage, int page) throws IOException, SAXException, FlickrException {
        PhotoList photos = new PhotoList();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_GET_PHOTOS));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.addAll(params.getAsParameters());
        if (perPage > 0) {
            parameters.add(new Parameter("per_page", "" + perPage));
        }
        if (page > 0) {
            parameters.add(new Parameter("page", "" + page));
        }
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transport.get(this.transport.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        int i = 0;
        while (i < photoNodes.getLength()) {
            Element photoElement = (Element)photoNodes.item(i);
            Photo obj = PhotoUtils.createPhoto(photoElement);
            photos.add(obj);
            ++i;
        }
        return photos;
    }
}

