/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.galleries;

import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.util.StringUtilities;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class SearchParameters {
    private static final long serialVersionUID = 12L;
    private String galleryId;
    private Set extras;
    public static final ThreadLocal DATE_FORMATS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final ThreadLocal MYSQL_DATE_FORMATS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static int DATE_POSTED_DESC = 0;
    public static int DATE_POSTED_ASC = 1;
    public static int DATE_TAKEN_DESC = 2;
    public static int DATE_TAKEN_ASC = 3;
    public static int INTERESTINGNESS_DESC = 4;
    public static int INTERESTINGNESS_ASC = 5;
    public static int RELEVANCE = 6;
    private int sort = 0;

    public void setExtras(Set extras) {
        this.extras = extras;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int order) {
        this.sort = order;
    }

    public Collection getAsParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String galleryId = this.getGalleryId();
        if (galleryId != null) {
            parameters.add(new Parameter("gallery_id", galleryId));
        }
        if (this.extras != null && !this.extras.isEmpty()) {
            parameters.add(new Parameter("extras", StringUtilities.join(this.extras, ",")));
        }
        if (this.sort != DATE_POSTED_DESC) {
            String sortArg = null;
            if (this.sort == DATE_POSTED_ASC) {
                sortArg = "date-posted-asc";
            }
            if (this.sort == DATE_TAKEN_DESC) {
                sortArg = "date-taken-desc";
            }
            if (this.sort == DATE_TAKEN_ASC) {
                sortArg = "date-taken-asc";
            }
            if (this.sort == INTERESTINGNESS_DESC) {
                sortArg = "interestingness-desc";
            }
            if (this.sort == INTERESTINGNESS_ASC) {
                sortArg = "interestingness-asc";
            }
            if (this.sort == RELEVANCE) {
                sortArg = "relevance";
            }
            if (sortArg != null) {
                parameters.add(new Parameter("sort", sortArg));
            }
        }
        return parameters;
    }

    public String getGalleryId() {
        return this.galleryId;
    }

    public void setGalleryId(String userId) {
        this.galleryId = userId;
    }
}

