/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.people;

import com.aetrion.flickr.contacts.OnlineStatus;
import com.aetrion.flickr.util.BuddyIconable;
import com.aetrion.flickr.util.StringUtilities;
import com.aetrion.flickr.util.UrlUtilities;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;

public class User
implements Serializable,
BuddyIconable {
    private static final long serialVersionUID = 12L;
    private static final ThreadLocal DATE_FORMATS = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private String id;
    private String username;
    private boolean admin;
    private boolean pro;
    private int iconFarm;
    private int iconServer;
    private String realName;
    private String location;
    private Date photosFirstDate;
    private Date photosFirstDateTaken;
    private Date faveDate;
    private int photosCount;
    private OnlineStatus online;
    private String awayMessage;
    private long bandwidthMax;
    private long bandwidthUsed;
    private long filesizeMax;
    private String mbox_sha1sum;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isPro() {
        return this.pro;
    }

    public void setPro(boolean pro) {
        this.pro = pro;
    }

    @Override
    public int getIconFarm() {
        return this.iconFarm;
    }

    @Override
    public void setIconFarm(int iconFarm) {
        this.iconFarm = iconFarm;
    }

    @Override
    public void setIconFarm(String iconFarm) {
        if (iconFarm != null) {
            this.setIconFarm(Integer.parseInt(iconFarm));
        }
    }

    @Override
    public int getIconServer() {
        return this.iconServer;
    }

    @Override
    public void setIconServer(int iconServer) {
        this.iconServer = iconServer;
    }

    @Override
    public void setIconServer(String iconServer) {
        if (iconServer != null) {
            this.setIconServer(Integer.parseInt(iconServer));
        }
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getBuddyIconUrl() {
        return UrlUtilities.createBuddyIconUrl(this.iconFarm, this.iconServer, this.id);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Date getPhotosFirstDate() {
        return this.photosFirstDate;
    }

    public void setPhotosFirstDate(Date photosFirstDate) {
        this.photosFirstDate = photosFirstDate;
    }

    public void setPhotosFirstDate(long photosFirstDate) {
        this.setPhotosFirstDate(new Date(photosFirstDate));
    }

    public void setPhotosFirstDate(String photosFirstDate) {
        if (photosFirstDate != null) {
            this.setPhotosFirstDate(Long.parseLong(photosFirstDate) * 1000L);
        }
    }

    public Date getPhotosFirstDateTaken() {
        return this.photosFirstDateTaken;
    }

    public void setPhotosFirstDateTaken(Date photosFirstDateTaken) {
        this.photosFirstDateTaken = photosFirstDateTaken;
    }

    public void setPhotosFirstDateTaken(String photosFirstDateTaken) {
        if (photosFirstDateTaken != null) {
            try {
                this.setPhotosFirstDateTaken(((DateFormat)DATE_FORMATS.get()).parse(photosFirstDateTaken));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setFaveDate(String faveDate) {
        this.setFaveDate(Long.parseLong(faveDate) * 1000L);
    }

    public void setFaveDate(long faveDate) {
        this.setFaveDate(new Date(faveDate));
    }

    public void setFaveDate(Date faveDate) {
        this.faveDate = faveDate;
    }

    public Date getFaveDate() {
        return this.faveDate;
    }

    public int getPhotosCount() {
        return this.photosCount;
    }

    public void setPhotosCount(int photosCount) {
        this.photosCount = photosCount;
    }

    public void setPhotosCount(String photosCount) {
        if (photosCount != null) {
            this.setPhotosCount(Integer.parseInt(photosCount));
        }
    }

    public OnlineStatus getOnline() {
        return this.online;
    }

    public void setOnline(OnlineStatus online) {
        this.online = online;
    }

    public String getAwayMessage() {
        return this.awayMessage;
    }

    public void setAwayMessage(String awayMessage) {
        this.awayMessage = awayMessage;
    }

    public long getBandwidthMax() {
        return this.bandwidthMax;
    }

    public void setBandwidthMax(long bandwidthMax) {
        this.bandwidthMax = bandwidthMax;
    }

    public void setBandwidthMax(String bandwidthMax) {
        if (bandwidthMax != null) {
            this.setBandwidthMax(Long.parseLong(bandwidthMax));
        }
    }

    public long getBandwidthUsed() {
        return this.bandwidthUsed;
    }

    public void setBandwidthUsed(long bandwidthUsed) {
        this.bandwidthUsed = bandwidthUsed;
    }

    public void setBandwidthUsed(String bandwidthUsed) {
        if (bandwidthUsed != null) {
            this.setBandwidthUsed(Long.parseLong(bandwidthUsed));
        }
    }

    public long getFilesizeMax() {
        return this.filesizeMax;
    }

    public void setFilesizeMax(long filesizeMax) {
        this.filesizeMax = filesizeMax;
    }

    public void setFilesizeMax(String filesizeMax) {
        if (filesizeMax != null) {
            this.setFilesizeMax(Long.parseLong(filesizeMax));
        }
    }

    public void setMbox_sha1sum(String mbox_sha1sum) {
        this.mbox_sha1sum = mbox_sha1sum;
    }

    public String getMbox_sha1sum() {
        return this.mbox_sha1sum;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        User test = (User)obj;
        Class<?> cl = this.getClass();
        Method[] method = cl.getMethods();
        int i = 0;
        while (i < method.length) {
            Matcher m = StringUtilities.getterPattern.matcher(method[i].getName());
            if (m.find() && !method[i].getName().equals("getClass")) {
                block21: {
                    String retType;
                    Object resTest;
                    Object res;
                    block20: {
                        block19: {
                            block17: {
                                block18: {
                                    res = method[i].invoke((Object)this, null);
                                    resTest = method[i].invoke((Object)test, null);
                                    retType = method[i].getReturnType().toString();
                                    if (retType.indexOf("class") != 0) break block17;
                                    if (res == null || resTest == null) break block18;
                                    if (!res.equals(resTest)) {
                                        return false;
                                    }
                                }
                                if (!(res == null && resTest == null || res != null && resTest != null)) {
                                    return false;
                                }
                            }
                            if (!retType.equals("int")) break block19;
                            if (!((Integer)res).equals((Integer)resTest)) {
                                return false;
                            }
                        }
                        if (!retType.equals("boolean")) break block20;
                        if (!((Boolean)res).equals((Boolean)resTest)) {
                            return false;
                        }
                    }
                    if (!retType.equals("long")) break block21;
                    if (!((Long)res).equals((Long)resTest)) {
                        return false;
                    }
                }
                try {
                    System.out.println("User#equals() missing type " + method[i].getName() + "|" + method[i].getReturnType().toString());
                }
                catch (IllegalAccessException ex) {
                    System.out.println("equals " + method[i].getName() + " " + ex);
                }
                catch (InvocationTargetException ex) {
                }
                catch (Exception ex) {
                    System.out.println("equals " + method[i].getName() + " " + ex);
                }
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        Class<?> cl = this.getClass();
        Method[] method = cl.getMethods();
        int i = 0;
        while (i < method.length) {
            Matcher m = StringUtilities.getterPattern.matcher(method[i].getName());
            if (m.find() && !method[i].getName().equals("getClass")) {
                Object res = null;
                try {
                    res = method[i].invoke((Object)this, null);
                }
                catch (IllegalAccessException ex) {
                    System.out.println("hashCode " + method[i].getName() + " " + ex);
                }
                catch (InvocationTargetException ex) {
                    // empty catch block
                }
                if (res != null) {
                    if (res instanceof Boolean) {
                        Boolean bool = (Boolean)res;
                        hash += bool.hashCode();
                    } else if (res instanceof Integer) {
                        Integer inte = (Integer)res;
                        hash += inte.hashCode();
                    } else if (res instanceof String) {
                        String str = (String)res;
                        hash += str.hashCode();
                    } else if (res instanceof Long) {
                        Long lon = (Long)res;
                        hash += lon.hashCode();
                    } else if (res instanceof OnlineStatus) {
                        OnlineStatus os = (OnlineStatus)res;
                        hash += os.hashCode();
                    } else {
                        System.out.println("User hashCode unrecognised object: " + res.getClass().getName());
                    }
                }
            }
            ++i;
        }
        return hash;
    }
}

