/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos.upload;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import com.aetrion.flickr.photos.upload.Ticket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UploadInterface {
    public static final String METHOD_CHECK_TICKETS = "flickr.photos.upload.checkTickets";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public UploadInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transport;
    }

    public List checkTickets(Set tickets) throws IOException, SAXException, FlickrException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_CHECK_TICKETS));
        parameters.add(new Parameter("api_key", this.apiKey));
        StringBuffer sb = new StringBuffer();
        Iterator it = tickets.iterator();
        while (it.hasNext()) {
            Object obj;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if ((obj = it.next()) instanceof Ticket) {
                sb.append(((Ticket)obj).getTicketId());
                continue;
            }
            sb.append(obj);
        }
        parameters.add(new Parameter("tickets", sb.toString()));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<Ticket> list = new ArrayList<Ticket>();
        Element uploaderElement = response.getPayload();
        NodeList ticketNodes = uploaderElement.getElementsByTagName("ticket");
        int n = ticketNodes.getLength();
        int i = 0;
        while (i < n) {
            Element ticketElement = (Element)ticketNodes.item(i);
            String id = ticketElement.getAttribute("id");
            String complete = ticketElement.getAttribute("complete");
            boolean invalid = "1".equals(ticketElement.getAttribute("invalid"));
            String photoId = ticketElement.getAttribute("photoid");
            Ticket info = new Ticket();
            info.setTicketId(id);
            info.setInvalid(invalid);
            info.setStatus(Integer.parseInt(complete));
            info.setPhotoId(photoId);
            list.add(info);
            ++i;
        }
        return list;
    }
}

