/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.uploader;

import com.aetrion.flickr.Response;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class UploaderResponse
implements Response {
    private String status;
    private String photoId;
    private String ticketId;
    private String errorCode;
    private String errorMessage;
    private Element responsePayLoad;

    @Override
    public void parse(Document document) {
        this.responsePayLoad = document.getDocumentElement();
        this.status = this.responsePayLoad.getAttribute("stat");
        if ("ok".equals(this.status)) {
            Element photoIdElement = (Element)this.responsePayLoad.getElementsByTagName("photoid").item(0);
            this.photoId = photoIdElement != null ? ((Text)photoIdElement.getFirstChild()).getData() : null;
            Element ticketIdElement = (Element)this.responsePayLoad.getElementsByTagName("ticketid").item(0);
            this.ticketId = ticketIdElement != null ? ((Text)ticketIdElement.getFirstChild()).getData() : null;
        } else {
            Element errElement = (Element)this.responsePayLoad.getElementsByTagName("err").item(0);
            this.errorCode = errElement.getAttribute("code");
            this.errorMessage = errElement.getAttribute("msg");
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getPhotoId() {
        return this.photoId;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    @Override
    public boolean isError() {
        return this.errorMessage != null;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Element getPayload() {
        return this.responsePayLoad;
    }

    @Override
    public Collection getPayloadCollection() {
        return null;
    }
}

