/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.util;

import com.aetrion.flickr.auth.Auth;
import com.aetrion.flickr.people.User;
import com.aetrion.flickr.util.AuthStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class FileAuthStore
implements AuthStore {
    private Map auths = new HashMap();
    private File authStoreDir;

    public FileAuthStore(File authStoreDir) throws IOException {
        this.authStoreDir = authStoreDir;
        if (!authStoreDir.exists()) {
            authStoreDir.mkdir();
        }
        if (!authStoreDir.canRead()) {
            throw new IOException("Cannot read " + authStoreDir.getCanonicalPath());
        }
        this.load();
    }

    private void load() throws IOException {
        File[] authFiles = this.authStoreDir.listFiles(new AuthFilenameFilter());
        int i = 0;
        while (i < authFiles.length) {
            if (authFiles[i].isFile() && authFiles[i].canRead()) {
                ObjectInputStream authStream = new ObjectInputStream(new FileInputStream(authFiles[i]));
                Auth authInst = null;
                try {
                    authInst = (Auth)authStream.readObject();
                }
                catch (ClassCastException classCastException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (authInst != null) {
                    this.auths.put(authInst.getUser().getId(), authInst);
                }
            }
            ++i;
        }
    }

    @Override
    public void store(Auth token) throws IOException {
        this.auths.put(token.getUser().getId(), token);
        String filename = String.valueOf(token.getUser().getId()) + ".auth";
        File outFile = new File(this.authStoreDir, filename);
        outFile.createNewFile();
        ObjectOutputStream authStream = new ObjectOutputStream(new FileOutputStream(outFile));
        authStream.writeObject(token);
        authStream.flush();
        authStream.close();
    }

    @Override
    public Auth retrieve(String nsid) {
        return (Auth)this.auths.get(nsid);
    }

    @Override
    public Auth[] retrieveAll() {
        return this.auths.values().toArray(new Auth[this.auths.size()]);
    }

    @Override
    public void clearAll() {
        this.auths.clear();
        File[] auths = this.authStoreDir.listFiles(new AuthFilenameFilter());
        int i = 0;
        while (i < auths.length) {
            auths[i].delete();
            ++i;
        }
    }

    @Override
    public void clear(String nsid) {
        this.auths.remove(nsid);
        File auth = new File(this.authStoreDir, String.valueOf(nsid) + ".auth");
        if (auth.exists()) {
            auth.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        FileAuthStore fas = new FileAuthStore(new File(String.valueOf(System.getProperty("user.home")) + File.separatorChar + "flickrauth"));
        Auth a = new Auth();
        User u = new User();
        u.setId("THISISMYNSID");
        a.setUser(u);
        fas.store(a);
        fas = null;
        fas = new FileAuthStore(new File(String.valueOf(System.getProperty("user.home")) + File.separatorChar + "flickrauth"));
        Auth a2 = fas.retrieve("THISISMYNSID");
        System.out.println(a2.getUser().getId());
    }

    static class AuthFilenameFilter
    implements FilenameFilter {
        private static final String suffix = ".auth";

        AuthFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(suffix);
        }
    }
}

