/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.util;

import com.aetrion.flickr.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;

public class UrlUtilities {
    public static final String UTF8 = "UTF-8";

    public static URL buildUrl(String host, int port, String path, List parameters) throws MalformedURLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("http://");
        buffer.append(host);
        if (port > 0) {
            buffer.append(":");
            buffer.append(port);
        }
        if (path == null) {
            path = "/";
        }
        buffer.append(path);
        Iterator iter = parameters.iterator();
        if (iter.hasNext()) {
            buffer.append("?");
        }
        while (iter.hasNext()) {
            Parameter p = (Parameter)iter.next();
            buffer.append(p.getName());
            buffer.append("=");
            Object value = p.getValue();
            if (value != null) {
                String string = value.toString();
                try {
                    string = URLEncoder.encode(string, UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                buffer.append(string);
            }
            if (!iter.hasNext()) continue;
            buffer.append("&");
        }
        return new URL(buffer.toString());
    }

    public static URL buildPostUrl(String host, int port, String path) throws MalformedURLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("http://");
        buffer.append(host);
        if (port > 0) {
            buffer.append(":");
            buffer.append(port);
        }
        if (path == null) {
            path = "/";
        }
        buffer.append(path);
        return new URL(buffer.toString());
    }

    private static String getMethod(List parameters) {
        for (Parameter parameter : parameters) {
            if (!"method".equals(parameter.getName())) continue;
            return String.valueOf(parameter.getValue());
        }
        return null;
    }

    private static boolean ignoreMethod(String method) {
        return method != null && "flickr.auth.checkToken".equals(method);
    }

    public static String createBuddyIconUrl(int iconFarm, int iconServer, String id) {
        String iconUrl = "http://www.flickr.com/images/buddyicon.jpg";
        if (iconServer > 0) {
            iconUrl = "http://farm" + iconFarm + ".static.flickr.com/" + iconServer + "/buddyicons/" + id + ".jpg";
        }
        return iconUrl;
    }
}

