/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ErrorBehaviour;
import ar.com.hjg.pngj.IBytesConsumer;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkReader
implements IBytesConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ChunkReader.class.getName());
    public final ChunkReaderMode mode;
    private final ChunkRaw chunkRaw;
    protected int read = 0;
    private int crcn = 0;
    private boolean crcCheck;
    protected ErrorBehaviour errorBehav = ErrorBehaviour.STRICT;

    public ChunkReader(int n, String string, long l, ChunkReaderMode chunkReaderMode) {
        if (chunkReaderMode == null || string.length() != 4 || n < 0) {
            throw new PngjInputException("Bad chunk paramenters: " + (Object)((Object)chunkReaderMode));
        }
        this.mode = chunkReaderMode;
        this.chunkRaw = new ChunkRaw(n, string, chunkReaderMode == ChunkReaderMode.BUFFER);
        this.chunkRaw.setOffset(l);
        this.crcCheck = chunkReaderMode != ChunkReaderMode.SKIP;
    }

    public ChunkRaw getChunkRaw() {
        return this.chunkRaw;
    }

    @Override
    public final int consume(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0) {
            throw new PngjException("negative length??");
        }
        if (this.read == 0 && this.crcn == 0 && this.crcCheck) {
            this.chunkRaw.updateCrc(this.chunkRaw.idbytes, 0, 4);
        }
        if ((n3 = this.chunkRaw.len - this.read) > n2) {
            n3 = n2;
        }
        if (n3 > 0 || this.crcn == 0) {
            if (this.crcCheck && this.mode != ChunkReaderMode.BUFFER && n3 > 0) {
                this.chunkRaw.updateCrc(byArray, n, n3);
            }
            if (this.mode == ChunkReaderMode.BUFFER) {
                if (this.chunkRaw.data != byArray && n3 > 0) {
                    System.arraycopy(byArray, n, this.chunkRaw.data, this.read, n3);
                }
            } else if (this.mode == ChunkReaderMode.PROCESS) {
                this.processData(this.read, byArray, n, n3);
            }
            this.read += n3;
            n += n3;
            n2 -= n3;
        }
        int n4 = 0;
        if (this.read == this.chunkRaw.len) {
            n4 = 4 - this.crcn;
            if (n4 > n2) {
                n4 = n2;
            }
            if (n4 > 0) {
                if (byArray != this.chunkRaw.crcval) {
                    System.arraycopy(byArray, n, this.chunkRaw.crcval, this.crcn, n4);
                }
                this.crcn += n4;
                if (this.crcn == 4) {
                    if (this.crcCheck) {
                        if (this.mode == ChunkReaderMode.BUFFER) {
                            this.chunkRaw.updateCrc(this.chunkRaw.data, 0, this.chunkRaw.len);
                        }
                        this.chunkRaw.checkCrc(this.errorBehav == ErrorBehaviour.STRICT);
                    }
                    LOGGER.debug("Chunk done");
                    this.chunkDone();
                }
            }
        }
        return n3 > 0 || n4 > 0 ? n3 + n4 : -1;
    }

    @Override
    public final boolean isDone() {
        return this.crcn == 4;
    }

    public void setCrcCheck(boolean bl) {
        if (this.read != 0 && bl && !this.crcCheck) {
            throw new PngjException("too late!");
        }
        this.crcCheck = bl;
    }

    protected abstract void processData(int var1, byte[] var2, int var3, int var4);

    protected abstract void chunkDone();

    public boolean isFromDeflatedSet() {
        return false;
    }

    public ErrorBehaviour getErrorBehav() {
        return this.errorBehav;
    }

    public void setErrorBehav(ErrorBehaviour errorBehaviour) {
        this.errorBehav = errorBehaviour;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.chunkRaw == null ? 0 : this.chunkRaw.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChunkReader chunkReader = (ChunkReader)object;
        return !(this.chunkRaw == null ? chunkReader.chunkRaw != null : !this.chunkRaw.equals(chunkReader.chunkRaw));
    }

    public String toString() {
        return this.chunkRaw.toString();
    }

    public static enum ChunkReaderMode {
        BUFFER,
        PROCESS,
        SKIP;

    }
}

