/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.DeflatedChunkReader;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DeflatedChunksSet {
    protected byte[] row;
    private int rowfilled;
    private int rowlen;
    private int rown;
    State state = State.WAITING_FOR_INPUT;
    private Inflater inf;
    private final boolean infOwn;
    private DeflatedChunkReader curChunk;
    protected final boolean callbackMode;
    private long nBytesIn = 0L;
    private long nBytesOut = 0L;
    int chunkNum = -1;
    int firstChunqSeqNum = -1;
    public final String chunkid;

    public DeflatedChunksSet(String string, boolean bl, int n, int n2, Inflater inflater, byte[] byArray) {
        this.chunkid = string;
        this.callbackMode = bl;
        this.rowlen = n;
        if (n < 1 || n2 < n) {
            throw new PngjException("bad inital row len " + n);
        }
        if (inflater != null) {
            this.inf = inflater;
            this.infOwn = false;
        } else {
            this.inf = new Inflater();
            this.infOwn = true;
        }
        this.row = byArray != null && byArray.length >= n ? byArray : new byte[n2];
        this.rown = -1;
        this.state = State.WAITING_FOR_INPUT;
        try {
            this.prepareForNextRow(n);
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
    }

    public DeflatedChunksSet(String string, boolean bl, int n, int n2) {
        this(string, bl, n, n2, null, null);
    }

    protected void appendNewChunk(DeflatedChunkReader deflatedChunkReader) {
        if (!this.chunkid.equals(deflatedChunkReader.getChunkRaw().id)) {
            throw new PngjInputException("Bad chunk inside IdatSet, id:" + deflatedChunkReader.getChunkRaw().id + ", expected:" + this.chunkid);
        }
        this.curChunk = deflatedChunkReader;
        ++this.chunkNum;
        if (this.firstChunqSeqNum >= 0) {
            deflatedChunkReader.setSeqNumExpected(this.chunkNum + this.firstChunqSeqNum);
        }
    }

    protected void processBytes(byte[] byArray, int n, int n2) {
        this.nBytesIn += (long)n2;
        if (n2 < 1 || this.state.isDone()) {
            return;
        }
        if (this.state == State.ROW_READY) {
            throw new PngjInputException("this should only be called if waitingForMoreInput");
        }
        if (this.inf.needsDictionary() || !this.inf.needsInput()) {
            throw new RuntimeException("should not happen");
        }
        this.inf.setInput(byArray, n, n2);
        if (this.callbackMode) {
            while (this.inflateData()) {
                int n3 = this.processRowCallback();
                this.prepareForNextRow(n3);
                if (!this.isDone()) continue;
                this.processDoneCallback();
            }
        } else {
            this.inflateData();
        }
    }

    private boolean inflateData() {
        try {
            if (this.state == State.ROW_READY) {
                throw new PngjException("invalid state");
            }
            if (this.state.isDone()) {
                return false;
            }
            int n = 0;
            if (this.row == null || this.row.length < this.rowlen) {
                this.row = new byte[this.rowlen];
            }
            if (this.rowfilled < this.rowlen && !this.inf.finished()) {
                try {
                    n = this.inf.inflate(this.row, this.rowfilled, this.rowlen - this.rowfilled);
                }
                catch (DataFormatException dataFormatException) {
                    throw new PngjInputException("error decompressing zlib stream ", dataFormatException);
                }
                this.rowfilled += n;
                this.nBytesOut += (long)n;
            }
            State state = null;
            state = this.rowfilled == this.rowlen ? State.ROW_READY : (!this.inf.finished() ? State.WAITING_FOR_INPUT : (this.rowfilled > 0 ? State.ROW_READY : State.DONE));
            this.state = state;
            if (this.state == State.ROW_READY) {
                this.preProcessRow();
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        return false;
    }

    protected void preProcessRow() {
    }

    protected int processRowCallback() {
        throw new PngjInputException("not implemented");
    }

    protected void processDoneCallback() {
    }

    public byte[] getInflatedRow() {
        return this.row;
    }

    public void prepareForNextRow(int n) {
        this.rowfilled = 0;
        ++this.rown;
        if (n < 1) {
            this.rowlen = 0;
            this.markAsDone();
        } else if (this.inf.finished()) {
            this.rowlen = 0;
            this.markAsDone();
        } else {
            this.state = State.WAITING_FOR_INPUT;
            this.rowlen = n;
            if (!this.callbackMode) {
                this.inflateData();
            }
        }
    }

    public boolean isWaitingForMoreInput() {
        return this.state == State.WAITING_FOR_INPUT;
    }

    public boolean isRowReady() {
        return this.state == State.ROW_READY;
    }

    public boolean isDone() {
        return this.state.isDone();
    }

    public boolean isClosed() {
        return this.state.isClosed();
    }

    public boolean ackNextChunkId(String string) {
        if (this.state.isClosed()) {
            return false;
        }
        if (string.equals(this.chunkid)) {
            return true;
        }
        if (!this.allowOtherChunksInBetween(string)) {
            if (this.state.isDone()) {
                if (!this.state.isClosed()) {
                    this.close();
                }
                return false;
            }
            throw new PngjInputException("Unexpected chunk " + string + " while " + this.chunkid + " set is not done");
        }
        return true;
    }

    public void close() {
        try {
            if (!this.state.isClosed()) {
                this.state = State.CLOSED;
            }
            if (this.infOwn && this.inf != null) {
                this.inf.end();
                this.inf = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void markAsDone() {
        if (!this.isDone()) {
            this.state = State.DONE;
        }
    }

    public int getRowLen() {
        return this.rowlen;
    }

    public int getRowFilled() {
        return this.rowfilled;
    }

    public int getRown() {
        return this.rown;
    }

    public boolean allowOtherChunksInBetween(String string) {
        return false;
    }

    public boolean isCallbackMode() {
        return this.callbackMode;
    }

    public long getBytesIn() {
        return this.nBytesIn;
    }

    public long getBytesOut() {
        return this.nBytesOut;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("idatSet : " + this.curChunk.getChunkRaw().id + " state=" + (Object)((Object)this.state) + " rows=" + this.rown + " bytes=" + this.nBytesIn + "/" + this.nBytesOut);
        return stringBuilder.toString();
    }

    private static enum State {
        WAITING_FOR_INPUT,
        ROW_READY,
        DONE,
        CLOSED;


        public boolean isDone() {
            return this == DONE || this == CLOSED;
        }

        public boolean isClosed() {
            return this == CLOSED;
        }
    }
}

