/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.Deinterlacer;
import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.RowInfo;
import java.util.Arrays;
import java.util.zip.Checksum;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdatSet
extends DeflatedChunksSet {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)IdatSet.class.getName());
    protected byte[] rowUnfiltered;
    protected byte[] rowUnfilteredPrev;
    protected final ImageInfo imgInfo;
    protected final Deinterlacer deinterlacer;
    final RowInfo rowinfo;
    protected int[] filterUseStat = new int[5];

    public IdatSet(String string, boolean bl, ImageInfo imageInfo, Deinterlacer deinterlacer) {
        this(string, bl, imageInfo, deinterlacer, null, null);
    }

    public IdatSet(String string, boolean bl, ImageInfo imageInfo, Deinterlacer deinterlacer, Inflater inflater, byte[] byArray) {
        super(string, bl, deinterlacer != null ? deinterlacer.getBytesToRead() + 1 : imageInfo.bytesPerRow + 1, imageInfo.bytesPerRow + 1, inflater, byArray);
        this.imgInfo = imageInfo;
        this.deinterlacer = deinterlacer;
        this.rowinfo = new RowInfo(imageInfo, deinterlacer);
        LOGGER.debug("Creating IDAT set ");
    }

    public void unfilterRow() {
        this.unfilterRow(this.rowinfo.bytesRow);
    }

    protected void unfilterRow(int n) {
        if (this.rowUnfiltered == null || this.rowUnfiltered.length < this.row.length) {
            this.rowUnfiltered = new byte[this.row.length];
            this.rowUnfilteredPrev = new byte[this.row.length];
        }
        if (this.rowinfo.rowNsubImg == 0) {
            Arrays.fill(this.rowUnfiltered, (byte)0);
        }
        byte[] byArray = this.rowUnfiltered;
        this.rowUnfiltered = this.rowUnfilteredPrev;
        this.rowUnfilteredPrev = byArray;
        byte by = this.row[0];
        if (!FilterType.isValidStandard(by)) {
            throw new PngjInputException("Filter type " + by + " invalid");
        }
        FilterType filterType = FilterType.getByVal(by);
        byte by2 = by;
        this.filterUseStat[by2] = this.filterUseStat[by2] + 1;
        this.rowUnfiltered[0] = this.row[0];
        switch (filterType) {
            case FILTER_NONE: {
                this.unfilterRowNone(n);
                break;
            }
            case FILTER_SUB: {
                this.unfilterRowSub(n);
                break;
            }
            case FILTER_UP: {
                this.unfilterRowUp(n);
                break;
            }
            case FILTER_AVERAGE: {
                this.unfilterRowAverage(n);
                break;
            }
            case FILTER_PAETH: {
                this.unfilterRowPaeth(n);
                break;
            }
            default: {
                throw new PngjInputException("Filter type " + by + " not implemented");
            }
        }
    }

    private void unfilterRowAverage(int n) {
        int n2 = 1 - this.imgInfo.bytesPixel;
        int n3 = 1;
        while (n3 <= n) {
            int n4 = n2 > 0 ? this.rowUnfiltered[n2] & 0xFF : 0;
            this.rowUnfiltered[n3] = (byte)(this.row[n3] + (n4 + (this.rowUnfilteredPrev[n3] & 0xFF)) / 2);
            ++n3;
            ++n2;
        }
    }

    private void unfilterRowNone(int n) {
        for (int i = 1; i <= n; ++i) {
            this.rowUnfiltered[i] = this.row[i];
        }
    }

    private void unfilterRowPaeth(int n) {
        int n2 = 1 - this.imgInfo.bytesPixel;
        int n3 = 1;
        while (n3 <= n) {
            int n4 = n2 > 0 ? this.rowUnfiltered[n2] & 0xFF : 0;
            int n5 = n2 > 0 ? this.rowUnfilteredPrev[n2] & 0xFF : 0;
            this.rowUnfiltered[n3] = (byte)(this.row[n3] + PngHelperInternal.filterPaethPredictor(n4, this.rowUnfilteredPrev[n3] & 0xFF, n5));
            ++n3;
            ++n2;
        }
    }

    private void unfilterRowSub(int n) {
        int n2;
        for (n2 = 1; n2 <= this.imgInfo.bytesPixel; ++n2) {
            this.rowUnfiltered[n2] = this.row[n2];
        }
        int n3 = 1;
        n2 = this.imgInfo.bytesPixel + 1;
        while (n2 <= n) {
            this.rowUnfiltered[n2] = (byte)(this.row[n2] + this.rowUnfiltered[n3]);
            ++n2;
            ++n3;
        }
    }

    private void unfilterRowUp(int n) {
        for (int i = 1; i <= n; ++i) {
            this.rowUnfiltered[i] = (byte)(this.row[i] + this.rowUnfilteredPrev[i]);
        }
    }

    @Override
    protected void preProcessRow() {
        super.preProcessRow();
        this.rowinfo.update(this.getRown());
        this.unfilterRow();
        this.rowinfo.updateBuf(this.rowUnfiltered, this.rowinfo.bytesRow + 1);
    }

    @Override
    protected int processRowCallback() {
        int n = this.advanceToNextRow();
        return n;
    }

    @Override
    protected void processDoneCallback() {
        super.processDoneCallback();
    }

    public int advanceToNextRow() {
        int n;
        if (this.deinterlacer == null) {
            n = this.getRown() >= this.imgInfo.rows - 1 ? 0 : this.imgInfo.bytesPerRow + 1;
        } else {
            boolean bl = this.deinterlacer.nextRow();
            int n2 = n = bl ? this.deinterlacer.getBytesToRead() + 1 : 0;
        }
        if (!this.callbackMode) {
            this.prepareForNextRow(n);
        }
        return n;
    }

    @Override
    public boolean isRowReady() {
        return !this.isWaitingForMoreInput();
    }

    public byte[] getUnfilteredRow() {
        return this.rowUnfiltered;
    }

    public Deinterlacer getDeinterlacer() {
        return this.deinterlacer;
    }

    void updateCrcs(Checksum ... checksumArray) {
        for (Checksum checksum : checksumArray) {
            if (checksum == null) continue;
            checksum.update(this.getUnfilteredRow(), 1, this.getRowFilled() - 1);
        }
    }

    @Override
    public void close() {
        super.close();
        this.rowUnfiltered = null;
        this.rowUnfilteredPrev = null;
    }

    public int[] getFilterUseStat() {
        return this.filterUseStat;
    }
}

