/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.IdatSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngReaderByte;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkACTL;
import ar.com.hjg.pngj.chunks.PngChunkFCTL;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class PngReaderApng
extends PngReaderByte {
    private Boolean apngKind = null;
    private boolean firsIdatApngFrame = false;
    protected PngChunkACTL actlChunk;
    private PngChunkFCTL fctlChunk;
    protected int frameNum = -1;

    public PngReaderApng(File file) {
        super(file);
        this.dontSkipChunk("fcTL");
    }

    public PngReaderApng(InputStream inputStream) {
        super(inputStream);
        this.dontSkipChunk("fcTL");
    }

    public boolean isApng() {
        if (this.apngKind == null) {
            this.actlChunk = (PngChunkACTL)this.getChunksList().getById1("acTL");
            this.apngKind = this.actlChunk != null;
            this.firsIdatApngFrame = this.fctlChunk != null;
        }
        return this.apngKind;
    }

    public void advanceToFrame(int n) {
        if (n < this.frameNum) {
            throw new PngjInputException("Cannot go backwards");
        }
        if (n >= this.getApngNumFrames()) {
            throw new PngjInputException("Frame out of range " + n);
        }
        if (n > this.frameNum) {
            this.addChunkToSkip("IDAT");
            this.addChunkToSkip("fdAT");
            if (this.chunkseq.getIdatSet() != null && !this.chunkseq.getIdatSet().isDone()) {
                this.chunkseq.getIdatSet().markAsDone();
            }
            while (this.frameNum < n & !this.chunkseq.isDone() && this.streamFeeder.feed(this.chunkseq) > 0) {
            }
        }
        if (n == this.frameNum) {
            this.dontSkipChunk("IDAT");
            this.dontSkipChunk("fdAT");
            this.rowNum = -1;
            this.imlinesSet = null;
            while (!this.chunkseq.isDone() && !this.chunkseq.getCurChunkReader().isFromDeflatedSet() && this.streamFeeder.feed(this.chunkseq) > 0) {
            }
        } else {
            throw new PngjInputException("unexpected error seeking from frame " + n);
        }
    }

    public boolean hasExtraStillImage() {
        return this.isApng() && !this.firsIdatApngFrame;
    }

    public int getApngNumFrames() {
        if (this.isApng()) {
            return this.actlChunk.getNumFrames();
        }
        return 0;
    }

    public int getApngNumPlays() {
        if (this.isApng()) {
            return this.actlChunk.getNumPlays();
        }
        return -1;
    }

    @Override
    public IImageLine readRow() {
        return super.readRow();
    }

    @Override
    public boolean hasMoreRows() {
        return super.hasMoreRows();
    }

    @Override
    public IImageLine readRow(int n) {
        return super.readRow(n);
    }

    @Override
    public IImageLineSet<? extends IImageLine> readRows() {
        return super.readRows();
    }

    @Override
    public IImageLineSet<? extends IImageLine> readRows(int n, int n2, int n3) {
        return super.readRows(n, n2, n3);
    }

    @Override
    public void readSkippingAllRows() {
        super.readSkippingAllRows();
    }

    @Override
    protected ChunkSeqReaderPng createChunkSeqReader() {
        ChunkSeqReaderPng chunkSeqReaderPng = new ChunkSeqReaderPng(false){

            @Override
            public boolean shouldSkipContent(int n, String string) {
                return super.shouldSkipContent(n, string);
            }

            @Override
            protected boolean isIdatKind(String string) {
                return string.equals("IDAT") || string.equals("fdAT");
            }

            @Override
            protected DeflatedChunksSet createIdatSet(String string) {
                IdatSet idatSet = new IdatSet(string, this.callbackMode, this.getCurImgInfo(), this.deinterlacer);
                return idatSet;
            }

            @Override
            protected void startNewChunk(int n, String string, long l) {
                super.startNewChunk(n, string, l);
            }

            @Override
            protected void postProcessChunk(ChunkReader chunkReader) {
                super.postProcessChunk(chunkReader);
                if (chunkReader.getChunkRaw().id.equals("fcTL")) {
                    ++PngReaderApng.this.frameNum;
                    List<PngChunk> list = PngReaderApng.this.chunkseq.getChunks();
                    PngReaderApng.this.fctlChunk = (PngChunkFCTL)list.get(list.size() - 1);
                    if (chunkReader.getChunkRaw().getOffset() != PngReaderApng.this.fctlChunk.getRaw().getOffset()) {
                        throw new PngjInputException("something went wrong");
                    }
                    ImageInfo imageInfo = PngReaderApng.this.fctlChunk.getEquivImageInfo();
                    PngReaderApng.this.getChunkseq().updateCurImgInfo(imageInfo);
                }
            }

            @Override
            protected boolean countChunkTypeAsAncillary(String string) {
                return super.countChunkTypeAsAncillary(string) && !string.equals("fdAT");
            }
        };
        return chunkSeqReaderPng;
    }

    public int getFrameNum() {
        return this.frameNum;
    }

    @Override
    public void end() {
        super.end();
    }

    public PngChunkFCTL getFctl() {
        return this.fctlChunk;
    }
}

