/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkCopyBehaviour;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.ChunksListForWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngMetadata;
import ar.com.hjg.pngj.pixels.PixelsWriter;
import ar.com.hjg.pngj.pixels.PixelsWriterDefault;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PngWriter
implements Closeable {
    public final ImageInfo imgInfo;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    private int passes = 1;
    private int currentpass = 0;
    private boolean shouldCloseStream = true;
    private int idatMaxSize = 0;
    protected PixelsWriter pixelsWriter;
    private final OutputStream os;
    private ChunkPredicate copyFromPredicate = null;
    private ChunksList copyFromList = null;
    protected StringBuilder debuginfo = new StringBuilder();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PngWriter.class.getName());

    public PngWriter(File file, ImageInfo imageInfo, boolean bl) {
        this(PngHelperInternal.ostreamFromFile(file, bl), imageInfo);
        this.setShouldCloseStream(true);
    }

    public PngWriter(File file, ImageInfo imageInfo) {
        this(file, imageInfo, true);
    }

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo) {
        this.os = outputStream;
        this.imgInfo = imageInfo;
        this.chunksList = new ChunksListForWrite(imageInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.pixelsWriter = this.createPixelsWriter(imageInfo);
    }

    private void initIdat() {
        this.pixelsWriter.setOs(this.os);
        this.pixelsWriter.setIdatMaxSize(this.idatMaxSize);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void writeEndChunk() {
        this.currentChunkGroup = 6;
        PngChunkIEND pngChunkIEND = new PngChunkIEND(this.imgInfo);
        pngChunkIEND.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(pngChunkIEND);
    }

    private void writeFirstChunks() {
        if (this.currentChunkGroup >= 4) {
            return;
        }
        int n = 0;
        this.currentChunkGroup = 1;
        this.queueChunksFromOther();
        n = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        n = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (n > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (n == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        n = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
    }

    private void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.queueChunksFromOther();
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> list = this.chunksList.getQueuedChunks();
        if (!list.isEmpty()) {
            throw new PngjOutputException(list.size() + " chunks were not written! Eg: " + list.get(0).toString());
        }
    }

    private void writeSignatureAndIHDR() {
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        this.currentChunkGroup = 0;
        PngChunkIHDR pngChunkIHDR = new PngChunkIHDR(this.imgInfo);
        pngChunkIHDR.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(pngChunkIHDR);
    }

    private void queueChunksFromOther() {
        if (this.copyFromList == null || this.copyFromPredicate == null) {
            return;
        }
        boolean bl = this.currentChunkGroup >= 4;
        for (PngChunk pngChunk : this.copyFromList.getChunks()) {
            boolean bl2;
            int n;
            if (pngChunk.getRaw().data == null || (n = pngChunk.getChunkGroup()) <= 4 && bl || n >= 4 && !bl || pngChunk.crit && !pngChunk.id.equals("PLTE") || !(bl2 = this.copyFromPredicate.match(pngChunk)) || !this.chunksList.getEquivalent(pngChunk).isEmpty() || !this.chunksList.getQueuedEquivalent(pngChunk).isEmpty()) continue;
            this.chunksList.queue(pngChunk);
        }
    }

    public void queueChunk(PngChunk pngChunk) {
        for (PngChunk pngChunk2 : this.chunksList.getQueuedEquivalent(pngChunk)) {
            this.getChunksList().removeChunk(pngChunk2);
        }
        this.chunksList.queue(pngChunk);
    }

    public void copyChunksFrom(ChunksList chunksList, int n) {
        this.copyChunksFrom(chunksList, ChunkCopyBehaviour.createPredicate(n, this.imgInfo));
    }

    public void copyChunksFrom(ChunksList chunksList) {
        this.copyChunksFrom(chunksList, 8);
    }

    public void copyChunksFrom(ChunksList chunksList, ChunkPredicate chunkPredicate) {
        if (this.copyFromList != null && chunksList != null) {
            LOGGER.warn("copyChunksFrom should only be called once");
        }
        if (chunkPredicate == null) {
            throw new PngjOutputException("copyChunksFrom requires a predicate");
        }
        this.copyFromList = chunksList;
        this.copyFromPredicate = chunkPredicate;
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 5) {
            throw new PngjOutputException("must be called after end()");
        }
        return this.pixelsWriter.getCompression();
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1 || !this.pixelsWriter.isDone()) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            if (this.pixelsWriter != null) {
                this.pixelsWriter.close();
            }
            if (this.currentChunkGroup < 5) {
                this.writeLastChunks();
            }
            if (this.currentChunkGroup < 6) {
                this.writeEndChunk();
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.pixelsWriter != null) {
            this.pixelsWriter.close();
        }
        if (this.shouldCloseStream && this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception exception) {
                LOGGER.warn("Error closing writer " + exception.toString());
            }
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setFilterType(FilterType filterType) {
        this.pixelsWriter.setFilterType(filterType);
    }

    public void setCompLevel(int n) {
        this.pixelsWriter.setDeflaterCompLevel(n);
    }

    public void setFilterPreserve(boolean bl) {
        if (bl) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_PRESERVE);
        } else if (this.pixelsWriter.getFilterType() == null) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_DEFAULT);
        }
    }

    public void setIdatMaxSize(int n) {
        this.idatMaxSize = n;
    }

    public void setShouldCloseStream(boolean bl) {
        this.shouldCloseStream = bl;
    }

    public void writeRow(IImageLine iImageLine) {
        this.writeRow(iImageLine, this.rowNum + 1);
    }

    public void writeRows(IImageLineSet<? extends IImageLine> iImageLineSet) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRow(iImageLineSet.getImageLineRawNum(i));
        }
    }

    public void writeRow(IImageLine iImageLine, int n) {
        ++this.rowNum;
        if (this.rowNum == this.imgInfo.rows) {
            this.rowNum = 0;
        }
        if (n == this.imgInfo.rows) {
            n = 0;
        }
        if (n >= 0 && this.rowNum != n) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + n);
        }
        if (this.rowNum == 0) {
            ++this.currentpass;
        }
        if (n == 0 && this.currentpass == this.passes) {
            this.initIdat();
            this.currentChunkGroup = 4;
        }
        byte[] byArray = this.pixelsWriter.getRowb();
        iImageLine.writeToPngRaw(byArray);
        this.pixelsWriter.processRow(byArray);
    }

    public void writeRowInt(int[] nArray) {
        this.writeRow(new ImageLineInt(this.imgInfo, nArray));
    }

    protected PixelsWriter createPixelsWriter(ImageInfo imageInfo) {
        PixelsWriterDefault pixelsWriterDefault = new PixelsWriterDefault(imageInfo);
        return pixelsWriterDefault;
    }

    public final PixelsWriter getPixelsWriter() {
        return this.pixelsWriter;
    }

    public String getDebuginfo() {
        return this.debuginfo.toString();
    }
}

