/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSPLT;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import java.util.ArrayList;
import java.util.List;

public class ChunksList {
    public static final int CHUNK_GROUP_0_IDHR = 0;
    public static final int CHUNK_GROUP_1_AFTERIDHR = 1;
    public static final int CHUNK_GROUP_2_PLTE = 2;
    public static final int CHUNK_GROUP_3_AFTERPLTE = 3;
    public static final int CHUNK_GROUP_4_IDAT = 4;
    public static final int CHUNK_GROUP_5_AFTERIDAT = 5;
    public static final int CHUNK_GROUP_6_END = 6;
    List<PngChunk> chunks = new ArrayList<PngChunk>();
    final ImageInfo imageInfo;
    boolean withPlte = false;

    public ChunksList(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public List<PngChunk> getChunks() {
        return this.chunks;
    }

    protected static List<PngChunk> getXById(List<PngChunk> list, final String string, final String string2) {
        if (string2 == null) {
            return ChunkHelper.filterList(list, new ChunkPredicate(){

                @Override
                public boolean match(PngChunk pngChunk) {
                    return pngChunk.id.equals(string);
                }
            });
        }
        return ChunkHelper.filterList(list, new ChunkPredicate(){

            @Override
            public boolean match(PngChunk pngChunk) {
                if (!pngChunk.id.equals(string)) {
                    return false;
                }
                if (pngChunk instanceof PngChunkTextVar && !((PngChunkTextVar)pngChunk).getKey().equals(string2)) {
                    return false;
                }
                return !(pngChunk instanceof PngChunkSPLT) || ((PngChunkSPLT)pngChunk).getPalName().equals(string2);
            }
        });
    }

    public void appendReadChunk(PngChunk pngChunk, int n) {
        pngChunk.setChunkGroup(n);
        this.chunks.add(pngChunk);
        if (pngChunk.id.equals("PLTE")) {
            this.withPlte = true;
        }
    }

    public List<? extends PngChunk> getById(String string) {
        return this.getById(string, null);
    }

    public List<? extends PngChunk> getById(String string, String string2) {
        return ChunksList.getXById(this.chunks, string, string2);
    }

    public PngChunk getById1(String string) {
        return this.getById1(string, false);
    }

    public PngChunk getById1(String string, boolean bl) {
        return this.getById1(string, null, bl);
    }

    public PngChunk getById1(String string, String string2, boolean bl) {
        List<? extends PngChunk> list = this.getById(string, string2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && (bl || !list.get(0).allowsMultiple())) {
            throw new PngjException("unexpected multiple chunks id=" + string);
        }
        return list.get(list.size() - 1);
    }

    public List<PngChunk> getEquivalent(final PngChunk pngChunk) {
        return ChunkHelper.filterList(this.chunks, new ChunkPredicate(){

            @Override
            public boolean match(PngChunk pngChunk2) {
                return ChunkHelper.equivalent(pngChunk2, pngChunk);
            }
        });
    }

    public String toString() {
        return "ChunkList: read: " + this.chunks.size();
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder(this.toString());
        stringBuilder.append("\n Read:\n");
        for (PngChunk pngChunk : this.chunks) {
            stringBuilder.append(pngChunk).append(" G=" + pngChunk.getChunkGroup() + "\n");
        }
        return stringBuilder.toString();
    }
}

