/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IdatChunkWriter;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.DeflaterEstimatorLz4;
import java.util.zip.Deflater;

public class CompressorStreamLz4
extends CompressorStream {
    private final DeflaterEstimatorLz4 lz4 = new DeflaterEstimatorLz4();
    private byte[] buf;
    private final int buffer_size;
    private int inbuf = 0;
    private static final int MAX_BUFFER_SIZE = 16000;

    public CompressorStreamLz4(IdatChunkWriter idatChunkWriter, int n, long l) {
        super(idatChunkWriter, n, l);
        this.buffer_size = (int)(l > 16000L ? 16000L : l);
    }

    public CompressorStreamLz4(IdatChunkWriter idatChunkWriter, int n, long l, Deflater deflater) {
        this(idatChunkWriter, n, l);
    }

    public CompressorStreamLz4(IdatChunkWriter idatChunkWriter, int n, long l, int n2, int n3) {
        this(idatChunkWriter, n, l);
    }

    @Override
    public void mywrite(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.done || this.closed) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.bytesIn += (long)n2;
        while (n2 > 0) {
            int n3;
            if (this.inbuf == 0 && (n2 >= 16000 || this.bytesIn == this.totalbytes)) {
                this.bytesOut += (long)this.lz4.compressEstim(byArray, n, n2);
                n2 = 0;
                continue;
            }
            if (this.buf == null) {
                this.buf = new byte[this.buffer_size];
            }
            int n4 = n3 = this.inbuf + n2 <= this.buffer_size ? n2 : this.buffer_size - this.inbuf;
            if (n3 > 0) {
                System.arraycopy(byArray, n, this.buf, this.inbuf, n3);
            }
            this.inbuf += n3;
            n2 -= n3;
            n += n3;
            if (this.inbuf != this.buffer_size) continue;
            this.compressFromBuffer();
        }
    }

    void compressFromBuffer() {
        if (this.inbuf > 0) {
            this.bytesOut += (long)this.lz4.compressEstim(this.buf, 0, this.inbuf);
            this.inbuf = 0;
        }
    }

    @Override
    public void done() {
        if (!this.done) {
            this.compressFromBuffer();
            this.done = true;
        }
    }

    @Override
    public void close() {
        this.done();
        if (!this.closed) {
            super.close();
            this.buf = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
    }
}

