/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.CompressorStreamDeflater;
import ar.com.hjg.pngj.pixels.CompressorStreamLz4;
import ar.com.hjg.pngj.pixels.FiltersPerformance;
import ar.com.hjg.pngj.pixels.PixelsWriter;
import java.util.LinkedList;

public class PixelsWriterMultiple
extends PixelsWriter {
    protected LinkedList<byte[]> rows;
    protected CompressorStream[] filterBank = new CompressorStream[6];
    protected byte[][] filteredRows = new byte[5][];
    protected byte[] filteredRowTmp;
    protected FiltersPerformance filtersPerf;
    protected int rowsPerBand = 0;
    protected int rowsPerBandCurrent = 0;
    protected int rowInBand = -1;
    protected int bandNum = -1;
    protected int firstRowInThisBand;
    protected int lastRowInThisBand;
    private boolean tryAdaptive = true;
    protected static final int HINT_MEMORY_DEFAULT_KB = 100;
    protected int hintMemoryKb = 100;
    private int hintRowsPerBand = 1000;
    private boolean useLz4 = true;

    public PixelsWriterMultiple(ImageInfo imageInfo) {
        super(imageInfo);
        this.filtersPerf = new FiltersPerformance(imageInfo);
        this.rows = new LinkedList();
        for (int i = 0; i < 2; ++i) {
            this.rows.add(new byte[this.buflen]);
        }
        this.filteredRowTmp = new byte[this.buflen];
    }

    @Override
    protected void filterAndWrite(byte[] byArray) {
        if (!this.initdone) {
            this.init();
        }
        if (byArray != this.rows.get(0)) {
            throw new RuntimeException("?");
        }
        this.setBandFromNewRown();
        byte[] byArray2 = this.rows.get(1);
        for (FilterType filterType : FilterType.getAllStandardNoneLast()) {
            if (this.currentRow == 0 && filterType != FilterType.FILTER_NONE && filterType != FilterType.FILTER_SUB) continue;
            byte[] byArray3 = this.filterRowWithFilterType(filterType, byArray, byArray2, this.filteredRows[filterType.val]);
            this.filterBank[filterType.val].write(byArray3);
            if (this.currentRow == 0 && filterType == FilterType.FILTER_SUB) {
                this.filterBank[FilterType.FILTER_PAETH.val].write(byArray3);
                this.filterBank[FilterType.FILTER_AVERAGE.val].write(byArray3);
                this.filterBank[FilterType.FILTER_UP.val].write(byArray3);
            }
            if (!this.tryAdaptive) continue;
            this.filtersPerf.updateFromFiltered(filterType, byArray3, this.currentRow);
        }
        this.filteredRows[0] = byArray;
        if (this.tryAdaptive) {
            FilterType n = this.filtersPerf.getPreferred();
            this.filterBank[5].write(this.filteredRows[n.val]);
        }
        if (this.currentRow == this.lastRowInThisBand) {
            int n = this.getBestCompressor();
            byte[] byArray4 = this.filterBank[n].getFirstBytes();
            int n2 = this.firstRowInThisBand;
            int n3 = 0;
            int n4 = this.lastRowInThisBand - this.firstRowInThisBand;
            while (n2 <= this.lastRowInThisBand) {
                byte by = byArray4[n3];
                byte[] byArray5 = null;
                byArray5 = n2 != this.lastRowInThisBand ? this.filterRowWithFilterType(FilterType.getByVal(by), this.rows.get(n4), this.rows.get(n4 + 1), this.filteredRowTmp) : this.filteredRows[by];
                this.sendToCompressedStream(byArray5);
                ++n2;
                --n4;
                ++n3;
            }
        }
        if (this.rows.size() > this.rowsPerBandCurrent) {
            this.rows.addFirst(this.rows.removeLast());
        } else {
            this.rows.addFirst(new byte[this.buflen]);
        }
    }

    @Override
    public byte[] getRowb() {
        return this.rows.get(0);
    }

    private void setBandFromNewRown() {
        boolean bl;
        boolean bl2 = bl = this.currentRow == 0 || this.currentRow > this.lastRowInThisBand;
        if (this.currentRow == 0) {
            this.bandNum = -1;
        }
        if (bl) {
            ++this.bandNum;
            this.rowInBand = 0;
        } else {
            ++this.rowInBand;
        }
        if (bl) {
            this.firstRowInThisBand = this.currentRow;
            this.lastRowInThisBand = this.firstRowInThisBand + this.rowsPerBand - 1;
            int n = this.firstRowInThisBand + 2 * this.rowsPerBand - 1;
            if (n >= this.imgInfo.rows) {
                this.lastRowInThisBand = this.imgInfo.rows - 1;
            }
            this.rowsPerBandCurrent = 1 + this.lastRowInThisBand - this.firstRowInThisBand;
            this.tryAdaptive = this.rowsPerBandCurrent > 3 && (this.rowsPerBandCurrent >= 10 || this.imgInfo.bytesPerRow >= 64);
            this.rebuildFiltersBank();
        }
    }

    private void rebuildFiltersBank() {
        long l = (long)this.rowsPerBandCurrent * (long)this.buflen;
        for (int i = 0; i <= 5; ++i) {
            CompressorStream compressorStream = this.filterBank[i];
            if (compressorStream == null || compressorStream.totalbytes != l) {
                if (compressorStream != null) {
                    compressorStream.close();
                }
                compressorStream = this.useLz4 ? new CompressorStreamLz4(null, this.buflen, l) : new CompressorStreamDeflater(null, this.buflen, l, 4, 0);
                this.filterBank[i] = compressorStream;
            } else {
                compressorStream.reset();
            }
            compressorStream.setStoreFirstByte(true, this.rowsPerBandCurrent);
        }
    }

    private int computeInitialRowsPerBand() {
        int n = (int)((double)this.hintMemoryKb * 1024.0 / (double)(this.imgInfo.bytesPerRow + 1) - 5.0);
        if (n < 1) {
            n = 1;
        }
        if (this.hintRowsPerBand > 0 && n > this.hintRowsPerBand) {
            n = this.hintRowsPerBand;
        }
        if (n > this.imgInfo.rows) {
            n = this.imgInfo.rows;
        }
        if (n > 2 && n > this.imgInfo.rows / 8) {
            int n2 = (this.imgInfo.rows + (n - 1)) / n;
            n = (this.imgInfo.rows + n2 / 2) / n2;
        }
        return n;
    }

    private int getBestCompressor() {
        int n;
        double d = Double.MAX_VALUE;
        int n2 = -1;
        int n3 = n = this.tryAdaptive ? 5 : 4;
        while (n >= 0) {
            CompressorStream compressorStream = this.filterBank[n];
            double d2 = compressorStream.getCompressionRatio();
            if (d2 <= d) {
                n2 = n;
                d = d2;
            }
            --n;
        }
        return n2;
    }

    @Override
    protected void initParams() {
        super.initParams();
        if (this.imgInfo.cols < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        if (this.imgInfo.rows < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        for (int i = 1; i <= 4; ++i) {
            if (this.filteredRows[i] != null && this.filteredRows[i].length >= this.buflen) continue;
            this.filteredRows[i] = new byte[this.buflen];
        }
        if (this.rowsPerBand == 0) {
            this.rowsPerBand = this.computeInitialRowsPerBand();
        }
    }

    @Override
    public void close() {
        super.close();
        this.rows.clear();
        for (CompressorStream compressorStream : this.filterBank) {
            compressorStream.close();
        }
    }

    public void setHintMemoryKb(int n) {
        this.hintMemoryKb = n <= 0 ? 100 : (n > 10000 ? 10000 : n);
    }

    public void setHintRowsPerBand(int n) {
        this.hintRowsPerBand = n;
    }

    public void setUseLz4(boolean bl) {
        this.useLz4 = bl;
    }

    public FiltersPerformance getFiltersPerf() {
        return this.filtersPerf;
    }

    public void setTryAdaptive(boolean bl) {
        this.tryAdaptive = bl;
    }
}

