/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.support.AbstractNumberValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;
import com.alibaba.citrus.service.form.support.CompareOperator;
import com.alibaba.citrus.service.form.support.NumberSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;

public class NumberCompareValidator
extends AbstractNumberValidator {
    private String fieldName;
    private CompareOperator op;

    public String getFieldName() {
        return this.fieldName;
    }

    public CompareOperator getOp() {
        return this.op;
    }

    public void setEqualTo(String fieldName) {
        this.setFieldName(CompareOperator.equalTo, fieldName);
    }

    public void setNotEqualTo(String fieldName) {
        this.setFieldName(CompareOperator.notEqualTo, fieldName);
    }

    public void setLessThan(String fieldName) {
        this.setFieldName(CompareOperator.lessThan, fieldName);
    }

    public void setGreaterThan(String fieldName) {
        this.setFieldName(CompareOperator.greaterThan, fieldName);
    }

    public void setLessThanOrEqualTo(String fieldName) {
        this.setFieldName(CompareOperator.lessThanOrEqualTo, fieldName);
    }

    public void setGreaterThanOrEqualTo(String fieldName) {
        this.setFieldName(CompareOperator.greaterThanOrEqualTo, fieldName);
    }

    private void setFieldName(CompareOperator op, String fieldName) {
        this.op = op;
        this.fieldName = StringUtil.trimToNull(fieldName);
    }

    @Override
    public void init(FieldConfig fieldConfig) throws Exception {
        super.init(fieldConfig);
        if (this.fieldName == null || this.op == null) {
            throw new IllegalArgumentException("One of the following attributes should be set: " + CollectionUtil.asList(CompareOperator.values()));
        }
        Assert.assertNotNull(fieldConfig.getGroupConfig().getFieldConfig(this.fieldName), "Field %s not exists", this.fieldName);
    }

    @Override
    protected boolean validate(Validator.Context context, String value) {
        Field fieldToCompare = Assert.assertNotNull(context.getField(this.fieldName), "field not found", new Object[0]);
        NumberSupport thisValue = new NumberSupport(this.getNumberType(), value);
        NumberSupport otherValue = new NumberSupport(this.getNumberType(), fieldToCompare.getStringValue());
        try {
            return this.getOp().accept(thisValue.compareTo(otherValue));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<NumberCompareValidator> {
    }
}

