/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.support;

import com.alibaba.citrus.expr.Expression;
import com.alibaba.citrus.expr.ExpressionContext;
import com.alibaba.citrus.expr.ExpressionFactory;
import com.alibaba.citrus.expr.ExpressionParseException;
import com.alibaba.citrus.expr.composite.CompositeExpressionFactory;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.configuration.FormConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.springext.support.BeanSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;

public abstract class AbstractValidator
extends BeanSupport
implements Validator,
MessageSourceAware {
    protected static final ExpressionFactory EXPRESSION_FACTORY = new CompositeExpressionFactory();
    private String id;
    private String messageCode;
    private Message message;
    private MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected boolean requiresMessage() {
        return true;
    }

    @Override
    public void init(FieldConfig fieldConfig) throws Exception {
        if (this.requiresMessage()) {
            boolean hasMessage = false;
            if (this.id != null && this.messageSource != null) {
                GroupConfig groupConfig = fieldConfig.getGroupConfig();
                FormConfig formConfig = groupConfig.getFormConfig();
                this.messageCode = formConfig.getMessageCodePrefix() + groupConfig.getName() + "." + fieldConfig.getName() + "." + this.id;
                boolean bl = hasMessage = this.getMessageFromMessageSource() != null;
            }
            if (!hasMessage) {
                Assert.assertNotNull(this.message, "no message", new Object[0]);
                this.message.compile();
            }
        }
    }

    private String getMessageFromMessageSource() {
        try {
            return this.messageSource.getMessage(this.messageCode, null, LocaleUtil.getContext().getLocale());
        }
        catch (NoSuchMessageException e) {
            return null;
        }
    }

    @Override
    public String getId() {
        return this.id == null ? this.getBeanName() : this.id;
    }

    public void setId(String id) {
        this.id = StringUtil.trimToNull(id);
    }

    @Override
    public final String getMessage(Validator.Context context) {
        String result = StringUtil.trimToNull(context.getMessage());
        if (result == null) {
            String messageFromMessageSource;
            Message message = this.message;
            if (this.messageCode != null && this.messageSource != null && (messageFromMessageSource = this.getMessageFromMessageSource()) != null) {
                message = new Message(messageFromMessageSource);
                message.compile();
            }
            if (message != null) {
                result = message.getMessageString(context.getMessageContext());
            }
        }
        return result;
    }

    public void setMessage(String message) {
        this.message = new Message(message);
    }

    @Override
    public Validator clone() {
        try {
            return (Validator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected static class Message
    implements Cloneable {
        private String message;
        private Expression messageExpression;

        public Message(String message) {
            this.message = StringUtil.trimToNull(message);
        }

        public void compile() {
            Assert.assertNotNull(this.message, "message", new Object[0]);
            try {
                this.messageExpression = EXPRESSION_FACTORY.createExpression(this.message);
            }
            catch (ExpressionParseException e) {
                throw new IllegalArgumentException("Invalid message for validator " + this.getClass().getSimpleName() + ": \"" + StringEscapeUtil.escapeJava(this.message) + "\"");
            }
        }

        public String getMessageString(ExpressionContext context) {
            return ObjectUtil.toString(this.messageExpression.evaluate(context), "");
        }

        public String toString() {
            return "ValidatorMessage[" + this.message + "]";
        }
    }
}

