/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.support;

import com.alibaba.citrus.service.mail.support.AbstractDataSource;
import com.alibaba.citrus.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.Resource;

public class ResourceDataSource
extends AbstractDataSource {
    private final Resource resource;

    public ResourceDataSource(Resource resource) {
        this(resource, null, null);
    }

    public ResourceDataSource(Resource resource, String name) {
        this(resource, name, null);
    }

    public ResourceDataSource(Resource resource, String name, String contentType) {
        super(name, contentType);
        this.resource = Assert.assertNotNull(resource, "resource", new Object[0]);
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            try {
                name = this.resource.getURL().getPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return name;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public String toString() {
        return this.resource.toString();
    }
}

