/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mappingrule.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.mappingrule.MappingRule;
import com.alibaba.citrus.service.mappingrule.MappingRuleNotFoundException;
import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.util.Assert;
import java.util.Collections;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MappingRuleServiceImpl
extends AbstractService<MappingRuleService>
implements MappingRuleService,
ApplicationContextAware {
    private static final String DEFAULT_BEAN_NAME = "mappingRuleService";
    private ApplicationContext factory;
    private MappingRuleService parent;
    private Map<String, MappingRule> rules;

    public void setApplicationContext(ApplicationContext factory) {
        this.factory = factory;
    }

    public MappingRuleService getParent() {
        return this.parent;
    }

    public void setParent(MappingRuleService parent) {
        this.parent = parent;
    }

    public void setRules(Map<String, MappingRule> rules) {
        this.rules = rules;
    }

    @Override
    protected void init() throws Exception {
        Assert.assertNotNull(this.factory, "beanFactory", new Object[0]);
        if (this.parent == null && this.factory.getParent() != null) {
            String parentBeanName = null;
            if (this.factory.getParent().containsBean(this.getBeanName())) {
                parentBeanName = this.getBeanName();
            } else if (this.factory.getParent().containsBean(DEFAULT_BEAN_NAME)) {
                parentBeanName = DEFAULT_BEAN_NAME;
            }
            if (parentBeanName != null) {
                this.parent = (MappingRuleService)this.factory.getParent().getBean(parentBeanName);
            }
        }
        if (this.rules == null) {
            this.rules = Collections.emptyMap();
        }
    }

    @Override
    public String getMappedName(String ruleType, String name) {
        MappingRule rule = this.rules.get(ruleType);
        if (rule == null) {
            if (this.parent == null) {
                throw new MappingRuleNotFoundException("Failed to get mapping rule of \"" + ruleType + "\"");
            }
            return this.parent.getMappedName(ruleType, name);
        }
        return rule.getMappedName(name);
    }
}

