/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextInfo;
import com.alibaba.citrus.service.requestcontext.session.ExactMatchesOnlySessionStore;
import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.SessionIDGenerator;
import com.alibaba.citrus.service.requestcontext.session.SessionInterceptor;
import com.alibaba.citrus.service.requestcontext.session.SessionModelEncoder;
import com.alibaba.citrus.service.requestcontext.session.SessionRequestContext;
import com.alibaba.citrus.service.requestcontext.session.SessionStore;
import com.alibaba.citrus.service.requestcontext.session.idgen.uuid.impl.UUIDGenerator;
import com.alibaba.citrus.service.requestcontext.session.impl.SessionModelEncoderImpl;
import com.alibaba.citrus.service.requestcontext.session.impl.SessionRequestContextImpl;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextFactory;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ExceptionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SessionRequestContextFactoryImpl
extends AbstractRequestContextFactory<SessionRequestContext> {
    private static final Logger log = LoggerFactory.getLogger(SessionRequestContext.class);
    private final ConfigImpl config = new ConfigImpl();

    public SessionConfig getConfig() {
        return this.config;
    }

    @Override
    protected void init() throws Exception {
        this.config.init();
        String storeName = this.config.getStoreMappings().getStoreNameForAttribute(this.config.getModelKey());
        if (storeName == null) {
            throw new IllegalArgumentException("No storage configured for session model: key=" + this.config.getModelKey());
        }
    }

    @Override
    public SessionRequestContext getRequestContextWrapper(RequestContext wrappedContext) {
        return new SessionRequestContextImpl(wrappedContext, this.config);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"session"};
    }

    @Override
    public RequestContextInfo.FeatureOrder[] featureOrders() {
        return new RequestContextInfo.FeatureOrder[]{new RequestContextInfo.AfterFeature("parseRequest"), new RequestContextInfo.RequiresFeature("lazyCommitHeaders")};
    }

    @Override
    protected Object dumpConfiguration() {
        return this.config;
    }

    static class AttributePattern {
        public final String patternName;
        public final String storeName;
        public final Pattern pattern;

        public static AttributePattern getDefaultPattern(String storeName) {
            return new AttributePattern(storeName, null, null);
        }

        public static AttributePattern getExactPattern(String storeName, String attrName) {
            return new AttributePattern(storeName, attrName, null);
        }

        public static AttributePattern getRegexPattern(String storeName, String regexName) {
            try {
                return new AttributePattern(storeName, regexName, Pattern.compile(regexName));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid regex pattern %s for store %s", regexName, storeName));
            }
        }

        private AttributePattern(String storeName, String patternName, Pattern pattern) {
            this.storeName = Assert.assertNotNull(StringUtil.trimToNull(storeName), "storeName", new Object[0]);
            this.patternName = patternName;
            this.pattern = pattern;
        }

        public boolean isDefaultPattern() {
            return this.patternName == null;
        }

        public boolean isRegexPattern() {
            return this.pattern != null;
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String toString() {
            ToStringBuilder buf = new ToStringBuilder();
            if (this.isDefaultPattern()) {
                buf.format("match=\"*\", store=\"%s\"", this.storeName);
            } else if (this.isRegexPattern()) {
                buf.format("match=~/%s/, store=\"%s\"", this.patternName, this.storeName);
            } else {
                buf.format("match=\"%s\", store=\"%s\"", this.patternName, this.storeName);
            }
            return buf.toString();
        }
    }

    private static class AttributeMatch
    implements Comparable<AttributeMatch> {
        private final AttributePattern pattern;
        private final int matchLength;

        public AttributeMatch(AttributePattern pattern, int matchLength) {
            this.pattern = pattern;
            this.matchLength = matchLength;
        }

        @Override
        public int compareTo(AttributeMatch o) {
            int result = o.matchLength - this.matchLength;
            if (result == 0) {
                int r1 = this.pattern.isRegexPattern() ? 0 : 1;
                int r2 = o.pattern.isRegexPattern() ? 0 : 1;
                return r2 - r1;
            }
            return result;
        }

        public String toString() {
            return new ToStringBuilder().append(this.pattern).append(", matchLength=").append(this.matchLength).toString();
        }
    }

    private static class StoreMappingsConfigImpl
    implements SessionConfig.StoreMappingsConfig {
        private AttributePattern[] patterns;
        private String defaultStore;
        private Map<String, String> attributeMatchCache;

        private StoreMappingsConfigImpl() {
        }

        public void setPatterns(AttributePattern[] patterns) {
            this.patterns = patterns;
        }

        private void init(SessionConfig.StoresConfig stores) {
            this.attributeMatchCache = CollectionUtil.createConcurrentHashMap();
            if (this.patterns == null) {
                this.patterns = new AttributePattern[0];
            }
            for (AttributePattern pattern : this.patterns) {
                if (pattern.isDefaultPattern()) {
                    if (this.defaultStore != null) {
                        throw new IllegalArgumentException("More than one stores mapped to *: " + this.defaultStore + " and " + pattern.getStoreName());
                    }
                    this.defaultStore = pattern.getStoreName();
                }
                if (stores.getStore(pattern.getStoreName()) != null) continue;
                throw new IllegalArgumentException("Undefined Session Store: " + pattern);
            }
        }

        @Override
        public String getStoreNameForAttribute(String attrName) {
            String matchedStoreName = this.attributeMatchCache.get(attrName = Assert.assertNotNull(StringUtil.trimToNull(attrName), "attrName", new Object[0]));
            if (matchedStoreName != null) {
                return matchedStoreName;
            }
            ArrayList matches = CollectionUtil.createArrayList(this.patterns.length);
            for (AttributePattern pattern : this.patterns) {
                if (pattern.isDefaultPattern()) {
                    matches.add(new AttributeMatch(pattern, 0));
                    continue;
                }
                if (pattern.isRegexPattern()) {
                    Matcher matcher = pattern.getPattern().matcher(attrName);
                    if (!matcher.find()) continue;
                    matches.add(new AttributeMatch(pattern, matcher.end() - matcher.start()));
                    continue;
                }
                if (!pattern.patternName.equals(attrName)) continue;
                matches.add(new AttributeMatch(pattern, pattern.patternName.length()));
            }
            Collections.sort(matches);
            if (log.isTraceEnabled()) {
                ToStringBuilder buf = new ToStringBuilder();
                buf.format("Attribute \"%s\" ", attrName);
                if (matches.isEmpty()) {
                    buf.append("does not match any pattern");
                } else {
                    buf.append("matches the following CANDIDATED patterns:").append(matches);
                }
                log.trace(buf.toString());
            }
            if (!matches.isEmpty()) {
                matchedStoreName = ((AttributeMatch)matches.get(0)).pattern.getStoreName();
            }
            if (matchedStoreName != null) {
                this.attributeMatchCache.put(attrName, matchedStoreName);
            }
            if (log.isDebugEnabled() && matchedStoreName != null) {
                log.debug("Session attribute {} is handled by session store: {}", (Object)attrName, (Object)matchedStoreName);
            }
            return matchedStoreName;
        }

        @Override
        public String[] getExactMatchedAttributeNames(String storeName) {
            storeName = Assert.assertNotNull(StringUtil.trimToNull(storeName), "no storeName", new Object[0]);
            LinkedHashSet<String> attrNames = CollectionUtil.createLinkedHashSet();
            for (AttributePattern pattern : this.patterns) {
                if (!pattern.getStoreName().equals(storeName)) continue;
                if (pattern.isDefaultPattern() || pattern.isRegexPattern()) {
                    return null;
                }
                attrNames.add(pattern.patternName);
            }
            return attrNames.toArray(new String[attrNames.size()]);
        }

        public String toString() {
            return new ToStringBuilder().append("StoreMappings").append(this.patterns).toString();
        }
    }

    private static class StoresConfigImpl
    implements SessionConfig.StoresConfig {
        private Map<String, SessionStore> stores;

        private StoresConfigImpl() {
        }

        public void setStores(LinkedHashMap<String, SessionStore> stores) {
            this.stores = stores;
        }

        @Override
        public SessionStore getStore(String storeName) {
            return this.stores.get(storeName);
        }

        @Override
        public String[] getStoreNames() {
            return this.stores.keySet().toArray(new String[this.stores.size()]);
        }

        private void init(SessionConfig sessionConfig) throws Exception {
            if (this.stores == null) {
                this.stores = CollectionUtil.createLinkedHashMap();
            }
            for (Map.Entry<String, SessionStore> entry : this.stores.entrySet()) {
                entry.getValue().init(entry.getKey(), sessionConfig);
            }
        }

        public String toString() {
            return new ToStringBuilder().append("Stores").append(this.stores).toString();
        }
    }

    private static class UrlEncodeConfigImpl
    implements SessionConfig.UrlEncodeConfig {
        private String name;

        private UrlEncodeConfigImpl() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        private void init() {
            this.name = StringUtil.defaultIfEmpty(this.name, "JSESSIONID");
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("name", this.name);
            return new ToStringBuilder().append("UrlEncodeConfig").append(mb).toString();
        }
    }

    private static class CookieConfigImpl
    implements SessionConfig.CookieConfig {
        private String name;
        private String domain;
        private String path;
        private Integer maxAge;
        private Boolean httpOnly;
        private Boolean secure;

        private CookieConfigImpl() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            if ((domain = StringUtil.trimToNull(domain)) != null && !domain.startsWith(".")) {
                domain = "." + domain;
            }
            this.domain = domain;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public int getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(int maxAge) {
            this.maxAge = maxAge;
        }

        @Override
        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public void setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
        }

        @Override
        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        private void init() {
            this.name = StringUtil.defaultIfEmpty(this.name, "JSESSIONID");
            this.domain = StringUtil.defaultIfEmpty(this.domain, COOKIE_DOMAIN_DEFAULT);
            this.path = StringUtil.defaultIfEmpty(this.path, "/");
            this.maxAge = ObjectUtil.defaultIfNull(this.maxAge, COOKIE_MAX_AGE_DEFAULT);
            this.httpOnly = ObjectUtil.defaultIfNull(this.httpOnly, COOKIE_HTTP_ONLY_DEFAULT);
            this.secure = ObjectUtil.defaultIfNull(this.secure, COOKIE_SECURE_DEFAULT);
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("name", this.name);
            mb.append("domain", this.domain);
            mb.append("path", this.path);
            mb.append("maxAge", String.format("%,d seconds", this.maxAge));
            mb.append("httpOnly", this.httpOnly);
            mb.append("secure", this.secure);
            return new ToStringBuilder().append("CookieConfig").append(mb).toString();
        }
    }

    private static class IdConfigImpl
    implements SessionConfig.IdConfig {
        private final CookieConfigImpl cookie = new CookieConfigImpl();
        private final UrlEncodeConfigImpl urlEncode = new UrlEncodeConfigImpl();
        private Boolean cookieEnabled;
        private Boolean urlEncodeEnabled;
        private SessionIDGenerator generator;

        private IdConfigImpl() {
        }

        @Override
        public boolean isCookieEnabled() {
            return this.cookieEnabled;
        }

        public void setCookieEnabled(boolean cookieEnabled) {
            this.cookieEnabled = cookieEnabled;
        }

        @Override
        public boolean isUrlEncodeEnabled() {
            return this.urlEncodeEnabled;
        }

        public void setUrlEncodeEnabled(boolean urlEncodeEnabled) {
            this.urlEncodeEnabled = urlEncodeEnabled;
        }

        @Override
        public SessionConfig.CookieConfig getCookie() {
            return this.cookie;
        }

        @Override
        public SessionConfig.UrlEncodeConfig getUrlEncode() {
            return this.urlEncode;
        }

        @Override
        public SessionIDGenerator getGenerator() {
            return this.generator;
        }

        public void setGenerator(SessionIDGenerator generator) {
            this.generator = generator;
        }

        private void init() {
            this.cookieEnabled = ObjectUtil.defaultIfNull(this.cookieEnabled, COOKIE_ENABLED_DEFAULT);
            this.urlEncodeEnabled = ObjectUtil.defaultIfNull(this.urlEncodeEnabled, URL_ENCODE_ENABLED_DEFAULT);
            if (this.generator == null) {
                this.generator = new UUIDGenerator();
                if (this.generator instanceof InitializingBean) {
                    try {
                        ((InitializingBean)this.generator).afterPropertiesSet();
                    }
                    catch (Exception e) {
                        throw ExceptionUtil.toRuntimeException(e);
                    }
                }
            }
            this.cookie.init();
            this.urlEncode.init();
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("cookieEnabled", this.cookieEnabled);
            mb.append("urlEncodeEnabled", this.urlEncodeEnabled);
            mb.append("cookieConfig", this.cookie);
            mb.append("urlEncodeConfig", this.urlEncode);
            mb.append("generator", this.generator);
            return new ToStringBuilder().append("IdConfig").append(mb).toString();
        }
    }

    private static class ConfigImpl
    implements SessionConfig {
        private final IdConfigImpl id = new IdConfigImpl();
        private final StoresConfigImpl stores = new StoresConfigImpl();
        private final StoreMappingsConfigImpl storeMappings = new StoreMappingsConfigImpl();
        private Integer maxInactiveInterval;
        private Long forceExpirationPeriod;
        private String modelKey;
        private Boolean keepInTouch;
        private SessionModelEncoder[] sessionModelEncoders;
        private SessionInterceptor[] sessionInterceptors;

        private ConfigImpl() {
        }

        @Override
        public int getMaxInactiveInterval() {
            return this.maxInactiveInterval;
        }

        public void setMaxInactiveInterval(int maxInactiveInterval) {
            this.maxInactiveInterval = maxInactiveInterval;
        }

        @Override
        public long getForceExpirationPeriod() {
            return this.forceExpirationPeriod;
        }

        public void setForceExpirationPeriod(long forceExpirationPeriod) {
            this.forceExpirationPeriod = forceExpirationPeriod;
        }

        @Override
        public String getModelKey() {
            return this.modelKey;
        }

        public void setModelKey(String modelKey) {
            this.modelKey = modelKey;
        }

        @Override
        public boolean isKeepInTouch() {
            return this.keepInTouch;
        }

        public void setKeepInTouch(boolean keepInTouch) {
            this.keepInTouch = keepInTouch;
        }

        @Override
        public SessionConfig.IdConfig getId() {
            return this.id;
        }

        @Override
        public SessionConfig.StoresConfig getStores() {
            return this.stores;
        }

        @Override
        public SessionConfig.StoreMappingsConfig getStoreMappings() {
            return this.storeMappings;
        }

        @Override
        public SessionModelEncoder[] getSessionModelEncoders() {
            return this.sessionModelEncoders;
        }

        public void setSessionModelEncoders(SessionModelEncoder[] sessionModelEncoders) {
            this.sessionModelEncoders = sessionModelEncoders;
        }

        @Override
        public SessionInterceptor[] getSessionInterceptors() {
            return this.sessionInterceptors;
        }

        public void setSessionInterceptors(SessionInterceptor[] sessionInterceptors) {
            this.sessionInterceptors = sessionInterceptors;
        }

        private void init() throws Exception {
            this.maxInactiveInterval = ObjectUtil.defaultIfNull(this.maxInactiveInterval, MAX_INACTIVE_INTERVAL_DEFAULT);
            this.forceExpirationPeriod = ObjectUtil.defaultIfNull(this.forceExpirationPeriod, FORCE_EXPIRATION_PERIOD_DEFAULT);
            this.modelKey = StringUtil.defaultIfEmpty(this.modelKey, "SESSION_MODEL");
            this.keepInTouch = ObjectUtil.defaultIfNull(this.keepInTouch, KEEP_IN_TOUCH_DEFAULT);
            this.id.init();
            this.stores.init(this);
            this.storeMappings.init(this.stores);
            for (String storeName : this.stores.getStoreNames()) {
                SessionStore store = this.stores.getStore(storeName);
                if (!(store instanceof ExactMatchesOnlySessionStore)) continue;
                String[] exactMatchedAttrNames = this.storeMappings.getExactMatchedAttributeNames(storeName);
                if (exactMatchedAttrNames == null) {
                    throw new IllegalArgumentException("Session store " + storeName + " only support exact matches to attribute names");
                }
                ((ExactMatchesOnlySessionStore)store).initAttributeNames(exactMatchedAttrNames);
            }
            if (ArrayUtil.isEmptyArray(this.sessionModelEncoders)) {
                this.sessionModelEncoders = new SessionModelEncoder[]{new SessionModelEncoderImpl()};
            }
            if (ArrayUtil.isEmptyArray(this.sessionInterceptors)) {
                this.sessionInterceptors = new SessionInterceptor[0];
            }
            for (SessionInterceptor l : this.sessionInterceptors) {
                l.init(this);
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("maxInactiveInterval", String.format("%,d seconds (%,3.2f hours)", this.maxInactiveInterval, (double)this.maxInactiveInterval.intValue() / 3600.0));
            mb.append("forceExpirationPeriod", String.format("%,d seconds (%,3.2f hours)", this.forceExpirationPeriod, (double)this.forceExpirationPeriod.longValue() / 3600.0));
            mb.append("modelKey", this.modelKey);
            mb.append("keepInTouch", this.keepInTouch);
            mb.append("idConfig", this.id);
            mb.append("stores", this.stores);
            mb.append("storeMappings", this.storeMappings);
            mb.append("sessionModelEncoders", this.sessionModelEncoders);
            return new ToStringBuilder().append("SessionConfig").append(mb).toString();
        }
    }
}

