/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.support;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.support.ResourceLoadingSupport;
import com.alibaba.citrus.util.Assert;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ContextResource;
import org.springframework.util.StringUtils;

public class ResourceAdapter
extends AbstractResource
implements ContextResource {
    private final ResourceLoadingSupport loader;
    private final String location;
    private final Resource resource;
    private final String description;

    public ResourceAdapter(String location, Resource resource) {
        this(location, resource, null);
    }

    public ResourceAdapter(String location, Resource resource, ResourceLoadingSupport loader) {
        this.loader = loader;
        this.location = location;
        this.resource = resource;
        this.description = "Resource[" + location + ", loaded by ResourceLoadingService]";
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPathWithinContext() {
        return this.location;
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public URL getURL() throws IOException {
        URL url = this.resource.getURL();
        if (url == null) {
            throw new IOException(this.getDescription() + " cannot be resolved as URL");
        }
        return url;
    }

    public File getFile() throws IOException {
        File file = this.resource.getFile();
        if (file == null) {
            throw new IOException(this.getDescription() + " cannot be resolved as File");
        }
        return file;
    }

    public InputStream getInputStream() throws IOException {
        InputStream istream = this.resource.getInputStream();
        if (istream == null) {
            throw new IOException(this.getDescription() + " cannot be resolved as InputStream");
        }
        return istream;
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        if (this.loader == null) {
            Assert.unsupportedOperation("no ResourceLoadingSupport", new Object[0]);
            return null;
        }
        String pathToUse = StringUtils.applyRelativePath((String)this.location, (String)relativePath);
        return this.loader.getResourceByPath(pathToUse);
    }

    public String getFilename() throws IllegalStateException {
        try {
            return StringUtils.getFilename((String)this.getURL().getPath());
        }
        catch (IOException e) {
            return super.getFilename();
        }
    }

    public long lastModified() {
        return this.resource.lastModified();
    }

    public int hashCode() {
        return 31 + (this.resource == null ? 0 : ((Object)this.resource).hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ResourceAdapter other = (ResourceAdapter)((Object)obj);
        return !(this.resource == null ? other.resource != null : !((Object)this.resource).equals(other.resource));
    }
}

