/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.upload;

import com.alibaba.citrus.service.upload.UploadConfiguration;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.HumanReadableSize;
import com.alibaba.citrus.util.SystemUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.File;
import java.util.Arrays;

public class UploadParameters
implements UploadConfiguration {
    private File repository;
    private HumanReadableSize sizeMax = new HumanReadableSize(-1L);
    private HumanReadableSize fileSizeMax = new HumanReadableSize(-1L);
    private HumanReadableSize sizeThreshold = new HumanReadableSize(10240L);
    private boolean keepFormFieldInMemory;
    private String[] fileNameKey;

    @Override
    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    @Override
    public HumanReadableSize getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(HumanReadableSize sizeMax) {
        this.sizeMax = Assert.assertNotNull(sizeMax, "sizeMax", new Object[0]);
    }

    public void setSizeMax(long sizeMax) {
        this.setSizeMax(new HumanReadableSize(sizeMax));
    }

    @Override
    public HumanReadableSize getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(HumanReadableSize fileSizeMax) {
        this.fileSizeMax = Assert.assertNotNull(fileSizeMax, "fileSizeMax", new Object[0]);
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.setFileSizeMax(new HumanReadableSize(fileSizeMax));
    }

    @Override
    public HumanReadableSize getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(HumanReadableSize sizeThreshold) {
        this.sizeThreshold = Assert.assertNotNull(sizeThreshold, "sizeThreshold", new Object[0]);
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = new HumanReadableSize(sizeThreshold);
    }

    @Override
    public boolean isKeepFormFieldInMemory() {
        return this.keepFormFieldInMemory;
    }

    public void setKeepFormFieldInMemory(boolean keepFormFieldInMemory) {
        this.keepFormFieldInMemory = keepFormFieldInMemory;
    }

    @Override
    public String[] getFileNameKey() {
        return this.fileNameKey;
    }

    public void setFileNameKey(String[] fileNameKey) {
        this.fileNameKey = fileNameKey;
    }

    public void applyDefaultValues() {
        if (this.sizeThreshold.getValue() == 0L) {
            this.keepFormFieldInMemory = true;
        }
        if (this.repository == null) {
            this.repository = new File(SystemUtil.getUserInfo().getTempDir());
        }
        if (!this.repository.exists() && !this.repository.mkdirs()) {
            throw new IllegalArgumentException("Could not create repository directory for file uploading: " + this.repository);
        }
        if (ArrayUtil.isEmptyArray(this.fileNameKey)) {
            this.fileNameKey = new String[]{"filename"};
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof UploadParameters)) {
            return false;
        }
        UploadParameters other = (UploadParameters)obj;
        if (this.repository == null ? other.repository != null : !this.repository.equals(other.repository)) {
            return false;
        }
        if (this.sizeMax != other.sizeMax) {
            return false;
        }
        if (this.fileSizeMax != other.fileSizeMax) {
            return false;
        }
        if (this.sizeThreshold != other.sizeThreshold) {
            return false;
        }
        if (this.keepFormFieldInMemory != other.keepFormFieldInMemory) {
            return false;
        }
        return Arrays.equals(this.fileNameKey, other.fileNameKey);
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("Repository Path", this.getRepository());
        mb.append("Maximum Request Size", this.getSizeMax());
        mb.append("Maximum File Size", this.getFileSizeMax());
        mb.append("Threshold before Writing to File", this.getSizeThreshold());
        mb.append("Keep Form Field in Memory", this.isKeepFormFieldInMemory());
        mb.append("File Name Key", this.getFileNameKey());
        return mb.toString();
    }
}

