/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class GenericURIBroker
extends URIBroker {
    @Override
    protected void setServerURI(URL uri) {
        this.setPathElements(Collections.singletonList(uri.getPath()));
    }

    public void setPathElements(List<String> path) {
        this.clearPathSegment(0);
        if (path != null) {
            for (String element : path) {
                this.addPathSegment(0, element);
            }
        }
    }

    public GenericURIBroker addPath(String path) {
        this.addPathSegment(0, path);
        return this;
    }

    public GenericURIBroker clearPath() {
        this.clearPathSegment(0);
        return this;
    }

    @Override
    protected URIBroker newInstance() {
        return new GenericURIBroker();
    }

    @Override
    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (!parent.getPathElements().isEmpty()) {
            this.setPathSegment(0, parent.getPathElements(), this.getPathElements());
        }
    }

    @Override
    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        this.clearPath();
        if (parent instanceof GenericURIBroker) {
            this.setPathSegment(0, parent.getPathElements());
        }
    }

    @Override
    protected int getPathSegmentCount() {
        return 1;
    }
}

