/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.VersionableSchemas;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class VersionableSchemasImpl
implements VersionableSchemas {
    private final Schema mainSchema;
    private final Map<String, Schema> versionedSchemas;
    private final Map<String, Schema> nameToSchemas;

    public VersionableSchemasImpl(Schema mainSchema, Schema[] versionedSchemas) {
        this.mainSchema = mainSchema;
        this.versionedSchemas = CollectionUtil.createTreeMap();
        for (Schema schema : versionedSchemas) {
            this.versionedSchemas.put(schema.getVersion(), schema);
        }
        TreeMap<String, Schema> mappings = CollectionUtil.createTreeMap();
        if (mainSchema != null) {
            mappings.put(mainSchema.getName(), mainSchema);
        }
        for (Schema versionedSchema : versionedSchemas) {
            mappings.put(versionedSchema.getName(), versionedSchema);
        }
        this.nameToSchemas = Collections.unmodifiableMap(mappings);
    }

    @Override
    public Schema getMainSchema() {
        return this.mainSchema;
    }

    @Override
    public Schema getVersionedSchema(String version) {
        return version == null ? this.mainSchema : this.versionedSchemas.get(version);
    }

    @Override
    public String[] getVersions() {
        return this.versionedSchemas.keySet().toArray(new String[this.versionedSchemas.size()]);
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        return this.nameToSchemas;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("Schemas[", new Object[0]);
        if (this.mainSchema == null) {
            buf.format("missing main schema", new Object[0]);
        } else if (this.mainSchema.getTargetNamespace() == null) {
            buf.format("%s", this.mainSchema.getName());
        } else {
            buf.format("%s, targetNamespace=%s", this.mainSchema.getName(), this.mainSchema.getTargetNamespace());
        }
        buf.format(", %d versioned schemas]", this.getVersions().length).start();
        for (String version : this.getVersions()) {
            buf.format("version %s: %s%n", version, this.getVersionedSchema(version));
        }
        return buf.end().toString();
    }
}

