/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.ActionEventUtil;
import com.alibaba.citrus.webx.WebxComponent;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AnalyzeURLValve
extends AbstractValve {
    private static final String DEFAULT_ACTION_PARAM_NAME = "action";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MappingRuleService mappingRuleService;
    @Autowired
    private WebxComponent component;
    private String homepage;
    private String actionParam;

    public void setActionParam(String actionParam) {
        this.actionParam = StringUtil.trimToNull(actionParam);
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = FileUtil.normalizeAbsolutePath(homepage);
    }

    @Override
    protected void init() throws Exception {
        if (this.actionParam == null) {
            this.actionParam = DEFAULT_ACTION_PARAM_NAME;
        }
        if (this.homepage == null) {
            this.setHomepage("/index");
        }
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        int lastSlashIndex;
        TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
        String target = null;
        String pathInfo = ServletUtil.getResourcePath(rundata.getRequest()).substring(this.component.getComponentPath().length());
        if ("/".equals(pathInfo)) {
            pathInfo = this.getHomepage();
        }
        pathInfo = (lastSlashIndex = pathInfo.lastIndexOf("/")) >= 0 ? pathInfo.substring(0, lastSlashIndex) + "/" + StringUtil.toCamelCase(pathInfo.substring(lastSlashIndex + 1)) : StringUtil.toCamelCase(pathInfo);
        target = this.mappingRuleService.getMappedName("extension.input", pathInfo);
        rundata.setTarget(target);
        String action = StringUtil.toCamelCase(StringUtil.trimToNull(rundata.getParameters().getString(this.actionParam)));
        action = this.mappingRuleService.getMappedName(DEFAULT_ACTION_PARAM_NAME, action);
        rundata.setAction(action);
        String actionEvent = ActionEventUtil.getEventName(rundata.getRequest());
        rundata.setActionEvent(actionEvent);
        pipelineContext.invokeNext();
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<AnalyzeURLValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "homepage", "actionParam");
        }
    }
}

