/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.service.requestcontext.buffered.BufferedRequestContext;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.service.template.TemplateService;
import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.citrus.turbine.support.ContextAdapter;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class RenderTemplateValve
extends AbstractValve {
    @Autowired
    private BufferedRequestContext bufferedRequestContext;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private MappingRuleService mappingRuleService;

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunDataInternal rundata = (TurbineRunDataInternal)TurbineUtil.getTurbineRunData(this.request);
        String target = Assert.assertNotNull(rundata.getTarget(), "Target was not specified", new Object[0]);
        if (!rundata.isRedirected()) {
            Context context = rundata.getContext();
            this.renderTemplate(this.getScreenTemplate(target), context, rundata);
            if (rundata.isLayoutEnabled()) {
                String layoutTemplate;
                String layoutTemplateOverride = rundata.getLayoutTemplateOverride();
                if (layoutTemplateOverride != null) {
                    target = layoutTemplateOverride;
                }
                if (this.templateService.exists(layoutTemplate = this.getLayoutTemplate(target))) {
                    String screenContent = ObjectUtil.defaultIfNull(this.bufferedRequestContext.popCharBuffer(), "");
                    context.put("screen_placeholder", screenContent);
                    this.renderTemplate(layoutTemplate, context, rundata);
                }
            }
        }
        pipelineContext.invokeNext();
    }

    protected String getScreenTemplate(String target) {
        return this.mappingRuleService.getMappedName("screen.template", target);
    }

    protected String getLayoutTemplate(String target) {
        return this.mappingRuleService.getMappedName("layout.template", target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTemplate(String templateName, Context context, TurbineRunDataInternal rundata) throws TemplateException, IOException {
        rundata.pushContext(context);
        try {
            this.templateService.writeTo(templateName, (TemplateContext)new ContextAdapter(context), rundata.getResponse().getWriter());
        }
        finally {
            rundata.popContext();
        }
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<RenderTemplateValve> {
    }
}

