/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.util;

import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlPageAttributeTool {
    private static final Logger log = LoggerFactory.getLogger(HtmlPageAttributeTool.class);
    private String title;
    private Map<String, String> bodyAttributes = CollectionUtil.createHashMap();
    private List<String> scripts = CollectionUtil.createLinkedList();
    private List<StyleSheet> styleSheets = CollectionUtil.createLinkedList();
    private List<String> styles = CollectionUtil.createLinkedList();
    private Map<String, String> metaTags = CollectionUtil.createHashMap();
    private Map<String, String> httpEquivs = CollectionUtil.createHashMap();

    public HtmlPageAttributeTool setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        if (StringUtil.isEmpty(this.title)) {
            return "";
        }
        return this.title;
    }

    @Deprecated
    public HtmlPageAttributeTool addAttribute(String name, String value) {
        log.info("Use of the addAttribute(name,value) method is deprecated.  Please use addBodyAttribute(name,value) instead.");
        return this.addBodyAttribute(name, value);
    }

    public HtmlPageAttributeTool addBodyAttribute(String name, String value) {
        this.bodyAttributes.put(name, value);
        return this;
    }

    public Map<String, String> getBodyAttributes() {
        return this.bodyAttributes;
    }

    public HtmlPageAttributeTool addScript(String scriptURL) {
        this.scripts.add(scriptURL);
        return this;
    }

    @Deprecated
    public HtmlPageAttributeTool setScript(String scriptURL) {
        log.info("Use of the setScript(scriptURL) method is deprecated.  Please use addScript(scriptURL) instead.");
        return this.addScript(scriptURL);
    }

    public List<String> getScripts() {
        return this.scripts;
    }

    public HtmlPageAttributeTool addStyleSheet(String styleSheetURL) {
        this.addStyleSheet(styleSheetURL, "screen", null, "text/css");
        return this;
    }

    public HtmlPageAttributeTool addStyleSheet(String styleSheetURL, String media, String title, String type) {
        StyleSheet ss = new StyleSheet(styleSheetURL);
        ss.setMedia(media);
        ss.setTitle(title);
        ss.setType(type);
        this.styleSheets.add(ss);
        return this;
    }

    @Deprecated
    public HtmlPageAttributeTool setStyleSheet(String styleSheetURL) {
        log.info("Use of the setStyleSheet(styleSheetURL) method is deprecated.  Please use addStyleSheet(styleSheetURL) instead.");
        return this.addStyleSheet(styleSheetURL);
    }

    @Deprecated
    public HtmlPageAttributeTool setStyleSheet(String styleSheetURL, String media) {
        log.info("Use of the setStyleSheet(styleSheetURL,media) method is deprecated.  Please use addStyleSheet(styleSheetURL,media) instead.");
        return this.addStyleSheet(styleSheetURL, media, null, "text/css");
    }

    public List<StyleSheet> getStyleSheets() {
        return this.styleSheets;
    }

    @Deprecated
    public HtmlPageAttributeTool setStyle(String styleText) {
        log.info("Use of the setStyle(styleText) method is deprecated.  Please use addStyle(styleText) instead.");
        return this.addStyle(styleText);
    }

    public HtmlPageAttributeTool addStyle(String styleText) {
        this.styles.add(styleText);
        return this;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public HtmlPageAttributeTool setKeywords(String keywords) {
        this.metaTags.put("keywords", keywords);
        return this;
    }

    public HtmlPageAttributeTool setHttpEquiv(String httpEquiv, String content) {
        this.httpEquivs.put(httpEquiv, content);
        return this;
    }

    public HtmlPageAttributeTool setDescription(String description) {
        this.metaTags.put("description", description);
        return this;
    }

    public HtmlPageAttributeTool setBackground(String url) {
        this.bodyAttributes.put("backgroup", url);
        return this;
    }

    public HtmlPageAttributeTool setBgColor(String color) {
        this.bodyAttributes.put("BGCOLOR", color);
        return this;
    }

    public HtmlPageAttributeTool setTextColor(String color) {
        this.bodyAttributes.put("TEXT", color);
        return this;
    }

    public HtmlPageAttributeTool setLinkColor(String color) {
        this.bodyAttributes.put("LINK", color);
        return this;
    }

    public HtmlPageAttributeTool setVlinkColor(String color) {
        this.bodyAttributes.put("VLINK", color);
        return this;
    }

    public HtmlPageAttributeTool setAlinkColor(String color) {
        this.bodyAttributes.put("ALINK", color);
        return this;
    }

    public Map<String, String> getHttpEquivs() {
        return this.httpEquivs;
    }

    public Map<String, String> getMetaTags() {
        return this.metaTags;
    }

    public String toString() {
        return "";
    }

    public static class Factory
    implements ToolFactory {
        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public Object createTool() throws Exception {
            return new HtmlPageAttributeTool();
        }
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<Factory> {
    }

    public class StyleSheet {
        private String url;
        private String title;
        private String media;
        private String type;

        public StyleSheet(String url) {
            this.setUrl(url);
        }

        public String getType() {
            return StringUtil.isEmpty(this.type) ? "" : this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUrl() {
            return this.url;
        }

        private void setUrl(String url) {
            this.url = url;
        }

        public String getTitle() {
            return StringUtil.isEmpty(this.title) ? "" : this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getMedia() {
            return StringUtil.isEmpty(this.media) ? "" : this.media;
        }

        public void setMedia(String media) {
            this.media = media;
        }
    }
}

