/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;

public class ObjectUtil {
    public static boolean isEmptyObject(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return StringUtil.isEmpty((String)object);
        }
        if (object.getClass().isArray()) {
            return ArrayUtil.isEmptyArray(object);
        }
        return false;
    }

    public static <T, S extends T> T defaultIfNull(T object, S defaultValue) {
        return (T)(object == null ? defaultValue : object);
    }

    public static boolean isEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (!object1.getClass().equals(object2.getClass())) {
            return false;
        }
        if (object1 instanceof Object[]) {
            return Arrays.deepEquals((Object[])object1, (Object[])object2);
        }
        if (object1 instanceof int[]) {
            return Arrays.equals((int[])object1, (int[])object2);
        }
        if (object1 instanceof long[]) {
            return Arrays.equals((long[])object1, (long[])object2);
        }
        if (object1 instanceof short[]) {
            return Arrays.equals((short[])object1, (short[])object2);
        }
        if (object1 instanceof byte[]) {
            return Arrays.equals((byte[])object1, (byte[])object2);
        }
        if (object1 instanceof double[]) {
            return Arrays.equals((double[])object1, (double[])object2);
        }
        if (object1 instanceof float[]) {
            return Arrays.equals((float[])object1, (float[])object2);
        }
        if (object1 instanceof char[]) {
            return Arrays.equals((char[])object1, (char[])object2);
        }
        if (object1 instanceof boolean[]) {
            return Arrays.equals((boolean[])object1, (boolean[])object2);
        }
        return object1.equals(object2);
    }

    public static boolean isSameType(Object object1, Object object2) {
        if (object1 == null || object2 == null) {
            return true;
        }
        return object1.getClass().equals(object2.getClass());
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static int identityHashCode(Object object) {
        return object == null ? 0 : System.identityHashCode(object);
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        return ObjectUtil.appendIdentityToString(new StringBuilder(), object).toString();
    }

    public static String identityToString(Object object, String nullStr) {
        if (object == null) {
            return nullStr;
        }
        return ObjectUtil.appendIdentityToString(new StringBuilder(), object).toString();
    }

    public static <A extends Appendable> A appendIdentityToString(A buffer, Object object) {
        Assert.assertNotNull(buffer, "appendable", new Object[0]);
        try {
            if (object == null) {
                buffer.append("null");
            } else {
                buffer.append(ClassUtil.getFriendlyClassNameForObject(object));
                buffer.append('@').append(Integer.toHexString(ObjectUtil.identityHashCode(object)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public static String toString(Object object) {
        return ObjectUtil.toString(object, "");
    }

    public static String toString(Object object, String nullStr) {
        if (object == null) {
            return nullStr;
        }
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        return object.toString();
    }
}

