/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteMethodRequestMarshaller
implements Marshaller<Request<DeleteMethodRequest>, DeleteMethodRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<DeleteMethodRequest> marshall(DeleteMethodRequest deleteMethodRequest) {
        if (deleteMethodRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteMethodRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)deleteMethodRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteMethodRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)deleteMethodRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteMethodRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)deleteMethodRequest.getHttpMethod()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

