/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ParameterAttribute;
import com.amazonaws.services.datapipeline.model.ParameterObject;
import com.amazonaws.services.datapipeline.model.transform.ParameterAttributeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ParameterObjectJsonMarshaller {
    private static ParameterObjectJsonMarshaller instance;

    public void marshall(ParameterObject parameterObject, JSONWriter jsonWriter) {
        if (parameterObject == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attributesList;
            jsonWriter.object();
            if (parameterObject.getId() != null) {
                jsonWriter.key("id").value((Object)parameterObject.getId());
            }
            if (!(attributesList = (SdkInternalList)parameterObject.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonWriter.key("attributes");
                jsonWriter.array();
                for (ParameterAttribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    ParameterAttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ParameterObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ParameterObjectJsonMarshaller();
        }
        return instance;
    }
}

