/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.transform.QueryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class QueryObjectsRequestMarshaller
implements Marshaller<Request<QueryObjectsRequest>, QueryObjectsRequest> {
    public Request<QueryObjectsRequest> marshall(QueryObjectsRequest queryObjectsRequest) {
        if (queryObjectsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)queryObjectsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.QueryObjects");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (queryObjectsRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value((Object)queryObjectsRequest.getPipelineId());
            }
            if (queryObjectsRequest.getQuery() != null) {
                jsonWriter.key("query");
                QueryJsonMarshaller.getInstance().marshall(queryObjectsRequest.getQuery(), jsonWriter);
            }
            if (queryObjectsRequest.getSphere() != null) {
                jsonWriter.key("sphere").value((Object)queryObjectsRequest.getSphere());
            }
            if (queryObjectsRequest.getMarker() != null) {
                jsonWriter.key("marker").value((Object)queryObjectsRequest.getMarker());
            }
            if (queryObjectsRequest.getLimit() != null) {
                jsonWriter.key("limit").value((Object)queryObjectsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

