/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.directory.AWSDirectoryServiceAsync;
import com.amazonaws.services.directory.AWSDirectoryServiceClient;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.ConnectDirectoryResult;
import com.amazonaws.services.directory.model.CreateAliasRequest;
import com.amazonaws.services.directory.model.CreateAliasResult;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.CreateComputerResult;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.CreateDirectoryResult;
import com.amazonaws.services.directory.model.CreateSnapshotRequest;
import com.amazonaws.services.directory.model.CreateSnapshotResult;
import com.amazonaws.services.directory.model.DeleteDirectoryRequest;
import com.amazonaws.services.directory.model.DeleteDirectoryResult;
import com.amazonaws.services.directory.model.DeleteSnapshotRequest;
import com.amazonaws.services.directory.model.DeleteSnapshotResult;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.services.directory.model.DescribeDirectoriesResult;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.services.directory.model.DescribeSnapshotsResult;
import com.amazonaws.services.directory.model.DisableRadiusRequest;
import com.amazonaws.services.directory.model.DisableRadiusResult;
import com.amazonaws.services.directory.model.DisableSsoRequest;
import com.amazonaws.services.directory.model.DisableSsoResult;
import com.amazonaws.services.directory.model.EnableRadiusRequest;
import com.amazonaws.services.directory.model.EnableRadiusResult;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.services.directory.model.EnableSsoResult;
import com.amazonaws.services.directory.model.GetDirectoryLimitsRequest;
import com.amazonaws.services.directory.model.GetDirectoryLimitsResult;
import com.amazonaws.services.directory.model.GetSnapshotLimitsRequest;
import com.amazonaws.services.directory.model.GetSnapshotLimitsResult;
import com.amazonaws.services.directory.model.RestoreFromSnapshotRequest;
import com.amazonaws.services.directory.model.RestoreFromSnapshotResult;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.services.directory.model.UpdateRadiusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSDirectoryServiceAsyncClient
extends AWSDirectoryServiceClient
implements AWSDirectoryServiceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSDirectoryServiceAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSDirectoryServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ConnectDirectoryResult> connectDirectoryAsync(ConnectDirectoryRequest request) {
        return this.connectDirectoryAsync(request, null);
    }

    @Override
    public Future<ConnectDirectoryResult> connectDirectoryAsync(final ConnectDirectoryRequest request, final AsyncHandler<ConnectDirectoryRequest, ConnectDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConnectDirectoryResult>(){

            @Override
            public ConnectDirectoryResult call() throws Exception {
                ConnectDirectoryResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.connectDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request) {
        return this.createAliasAsync(request, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(final CreateAliasRequest request, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createAlias(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateComputerResult> createComputerAsync(CreateComputerRequest request) {
        return this.createComputerAsync(request, null);
    }

    @Override
    public Future<CreateComputerResult> createComputerAsync(final CreateComputerRequest request, final AsyncHandler<CreateComputerRequest, CreateComputerResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateComputerResult>(){

            @Override
            public CreateComputerResult call() throws Exception {
                CreateComputerResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createComputer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(CreateDirectoryRequest request) {
        return this.createDirectoryAsync(request, null);
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(final CreateDirectoryRequest request, final AsyncHandler<CreateDirectoryRequest, CreateDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDirectoryResult>(){

            @Override
            public CreateDirectoryResult call() throws Exception {
                CreateDirectoryResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.createSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(DeleteDirectoryRequest request) {
        return this.deleteDirectoryAsync(request, null);
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(final DeleteDirectoryRequest request, final AsyncHandler<DeleteDirectoryRequest, DeleteDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDirectoryResult>(){

            @Override
            public DeleteDirectoryResult call() throws Exception {
                DeleteDirectoryResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.deleteDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotAsync(request, null);
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(final DeleteSnapshotRequest request, final AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSnapshotResult>(){

            @Override
            public DeleteSnapshotResult call() throws Exception {
                DeleteSnapshotResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.deleteSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(DescribeDirectoriesRequest request) {
        return this.describeDirectoriesAsync(request, null);
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(final DescribeDirectoriesRequest request, final AsyncHandler<DescribeDirectoriesRequest, DescribeDirectoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDirectoriesResult>(){

            @Override
            public DescribeDirectoriesResult call() throws Exception {
                DescribeDirectoriesResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.describeDirectories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync() {
        return this.describeDirectoriesAsync(new DescribeDirectoriesRequest());
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(AsyncHandler<DescribeDirectoriesRequest, DescribeDirectoriesResult> asyncHandler) {
        return this.describeDirectoriesAsync(new DescribeDirectoriesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request) {
        return this.describeSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest request, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.describeSnapshots(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync() {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest());
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<DisableRadiusResult> disableRadiusAsync(DisableRadiusRequest request) {
        return this.disableRadiusAsync(request, null);
    }

    @Override
    public Future<DisableRadiusResult> disableRadiusAsync(final DisableRadiusRequest request, final AsyncHandler<DisableRadiusRequest, DisableRadiusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableRadiusResult>(){

            @Override
            public DisableRadiusResult call() throws Exception {
                DisableRadiusResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.disableRadius(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableSsoResult> disableSsoAsync(DisableSsoRequest request) {
        return this.disableSsoAsync(request, null);
    }

    @Override
    public Future<DisableSsoResult> disableSsoAsync(final DisableSsoRequest request, final AsyncHandler<DisableSsoRequest, DisableSsoResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableSsoResult>(){

            @Override
            public DisableSsoResult call() throws Exception {
                DisableSsoResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.disableSso(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableRadiusResult> enableRadiusAsync(EnableRadiusRequest request) {
        return this.enableRadiusAsync(request, null);
    }

    @Override
    public Future<EnableRadiusResult> enableRadiusAsync(final EnableRadiusRequest request, final AsyncHandler<EnableRadiusRequest, EnableRadiusResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableRadiusResult>(){

            @Override
            public EnableRadiusResult call() throws Exception {
                EnableRadiusResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.enableRadius(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableSsoResult> enableSsoAsync(EnableSsoRequest request) {
        return this.enableSsoAsync(request, null);
    }

    @Override
    public Future<EnableSsoResult> enableSsoAsync(final EnableSsoRequest request, final AsyncHandler<EnableSsoRequest, EnableSsoResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableSsoResult>(){

            @Override
            public EnableSsoResult call() throws Exception {
                EnableSsoResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.enableSso(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(GetDirectoryLimitsRequest request) {
        return this.getDirectoryLimitsAsync(request, null);
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(final GetDirectoryLimitsRequest request, final AsyncHandler<GetDirectoryLimitsRequest, GetDirectoryLimitsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDirectoryLimitsResult>(){

            @Override
            public GetDirectoryLimitsResult call() throws Exception {
                GetDirectoryLimitsResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.getDirectoryLimits(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync() {
        return this.getDirectoryLimitsAsync(new GetDirectoryLimitsRequest());
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(AsyncHandler<GetDirectoryLimitsRequest, GetDirectoryLimitsResult> asyncHandler) {
        return this.getDirectoryLimitsAsync(new GetDirectoryLimitsRequest(), asyncHandler);
    }

    @Override
    public Future<GetSnapshotLimitsResult> getSnapshotLimitsAsync(GetSnapshotLimitsRequest request) {
        return this.getSnapshotLimitsAsync(request, null);
    }

    @Override
    public Future<GetSnapshotLimitsResult> getSnapshotLimitsAsync(final GetSnapshotLimitsRequest request, final AsyncHandler<GetSnapshotLimitsRequest, GetSnapshotLimitsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSnapshotLimitsResult>(){

            @Override
            public GetSnapshotLimitsResult call() throws Exception {
                GetSnapshotLimitsResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.getSnapshotLimits(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(RestoreFromSnapshotRequest request) {
        return this.restoreFromSnapshotAsync(request, null);
    }

    @Override
    public Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(final RestoreFromSnapshotRequest request, final AsyncHandler<RestoreFromSnapshotRequest, RestoreFromSnapshotResult> asyncHandler) {
        return this.executorService.submit(new Callable<RestoreFromSnapshotResult>(){

            @Override
            public RestoreFromSnapshotResult call() throws Exception {
                RestoreFromSnapshotResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.restoreFromSnapshot(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRadiusResult> updateRadiusAsync(UpdateRadiusRequest request) {
        return this.updateRadiusAsync(request, null);
    }

    @Override
    public Future<UpdateRadiusResult> updateRadiusAsync(final UpdateRadiusRequest request, final AsyncHandler<UpdateRadiusRequest, UpdateRadiusResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateRadiusResult>(){

            @Override
            public UpdateRadiusResult call() throws Exception {
                UpdateRadiusResult result;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.updateRadius(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

