/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;
import java.util.Map;

public class ItemCollectionMetricsJsonMarshaller {
    private static ItemCollectionMetricsJsonMarshaller instance;

    public void marshall(ItemCollectionMetrics itemCollectionMetrics, JSONWriter jsonWriter) {
        if (itemCollectionMetrics == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Double> sizeEstimateRangeGBList;
            jsonWriter.object();
            Map<String, AttributeValue> itemCollectionKeyMap = itemCollectionMetrics.getItemCollectionKey();
            if (itemCollectionKeyMap != null) {
                jsonWriter.key("ItemCollectionKey");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> itemCollectionKeyMapValue : itemCollectionKeyMap.entrySet()) {
                    if (itemCollectionKeyMapValue.getValue() == null) continue;
                    jsonWriter.key(itemCollectionKeyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(itemCollectionKeyMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if ((sizeEstimateRangeGBList = itemCollectionMetrics.getSizeEstimateRangeGB()) != null) {
                jsonWriter.key("SizeEstimateRangeGB");
                jsonWriter.array();
                for (Double sizeEstimateRangeGBListValue : sizeEstimateRangeGBList) {
                    if (sizeEstimateRangeGBListValue == null) continue;
                    jsonWriter.value((Object)sizeEstimateRangeGBListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ItemCollectionMetricsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ItemCollectionMetricsJsonMarshaller();
        }
        return instance;
    }
}

