/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class ConditionJsonMarshaller {
    private static ConditionJsonMarshaller instance;

    public void marshall(Condition condition, SdkJsonGenerator jsonGenerator) {
        if (condition == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<AttributeValue> attributeValueListList = condition.getAttributeValueList();
            if (attributeValueListList != null) {
                jsonGenerator.writeFieldName("AttributeValueList");
                jsonGenerator.writeStartArray();
                for (AttributeValue attributeValueListListValue : attributeValueListList) {
                    if (attributeValueListListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (condition.getComparisonOperator() != null) {
                jsonGenerator.writeFieldName("ComparisonOperator").writeValue(condition.getComparisonOperator());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConditionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConditionJsonMarshaller();
        }
        return instance;
    }
}

