/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputDescriptionJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class GlobalSecondaryIndexDescriptionJsonMarshaller {
    private static GlobalSecondaryIndexDescriptionJsonMarshaller instance;

    public void marshall(GlobalSecondaryIndexDescription globalSecondaryIndexDescription, SdkJsonGenerator jsonGenerator) {
        if (globalSecondaryIndexDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonGenerator.writeStartObject();
            if (globalSecondaryIndexDescription.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(globalSecondaryIndexDescription.getIndexName());
            }
            if ((keySchemaList = globalSecondaryIndexDescription.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (globalSecondaryIndexDescription.getProjection() != null) {
                jsonGenerator.writeFieldName("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(globalSecondaryIndexDescription.getProjection(), jsonGenerator);
            }
            if (globalSecondaryIndexDescription.getIndexStatus() != null) {
                jsonGenerator.writeFieldName("IndexStatus").writeValue(globalSecondaryIndexDescription.getIndexStatus());
            }
            if (globalSecondaryIndexDescription.getBackfilling() != null) {
                jsonGenerator.writeFieldName("Backfilling").writeValue(globalSecondaryIndexDescription.getBackfilling().booleanValue());
            }
            if (globalSecondaryIndexDescription.getProvisionedThroughput() != null) {
                jsonGenerator.writeFieldName("ProvisionedThroughput");
                ProvisionedThroughputDescriptionJsonMarshaller.getInstance().marshall(globalSecondaryIndexDescription.getProvisionedThroughput(), jsonGenerator);
            }
            if (globalSecondaryIndexDescription.getIndexSizeBytes() != null) {
                jsonGenerator.writeFieldName("IndexSizeBytes").writeValue(globalSecondaryIndexDescription.getIndexSizeBytes().longValue());
            }
            if (globalSecondaryIndexDescription.getItemCount() != null) {
                jsonGenerator.writeFieldName("ItemCount").writeValue(globalSecondaryIndexDescription.getItemCount().longValue());
            }
            if (globalSecondaryIndexDescription.getIndexArn() != null) {
                jsonGenerator.writeFieldName("IndexArn").writeValue(globalSecondaryIndexDescription.getIndexArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GlobalSecondaryIndexDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalSecondaryIndexDescriptionJsonMarshaller();
        }
        return instance;
    }
}

