/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class LocalSecondaryIndexJsonMarshaller {
    private static LocalSecondaryIndexJsonMarshaller instance;

    public void marshall(LocalSecondaryIndex localSecondaryIndex, SdkJsonGenerator jsonGenerator) {
        if (localSecondaryIndex == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonGenerator.writeStartObject();
            if (localSecondaryIndex.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(localSecondaryIndex.getIndexName());
            }
            if ((keySchemaList = localSecondaryIndex.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (localSecondaryIndex.getProjection() != null) {
                jsonGenerator.writeFieldName("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(localSecondaryIndex.getProjection(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LocalSecondaryIndexJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalSecondaryIndexJsonMarshaller();
        }
        return instance;
    }
}

