/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class TableDescriptionJsonMarshaller {
    private static TableDescriptionJsonMarshaller instance;

    public void marshall(TableDescription tableDescription, SdkJsonGenerator jsonGenerator) {
        if (tableDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<GlobalSecondaryIndexDescription> globalSecondaryIndexesList;
            List<LocalSecondaryIndexDescription> localSecondaryIndexesList;
            List<KeySchemaElement> keySchemaList;
            jsonGenerator.writeStartObject();
            List<AttributeDefinition> attributeDefinitionsList = tableDescription.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonGenerator.writeFieldName("AttributeDefinitions");
                jsonGenerator.writeStartArray();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinitionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (tableDescription.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(tableDescription.getTableName());
            }
            if ((keySchemaList = tableDescription.getKeySchema()) != null) {
                jsonGenerator.writeFieldName("KeySchema");
                jsonGenerator.writeStartArray();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (tableDescription.getTableStatus() != null) {
                jsonGenerator.writeFieldName("TableStatus").writeValue(tableDescription.getTableStatus());
            }
            if (tableDescription.getCreationDateTime() != null) {
                jsonGenerator.writeFieldName("CreationDateTime").writeValue(tableDescription.getCreationDateTime());
            }
            if (tableDescription.getProvisionedThroughput() != null) {
                jsonGenerator.writeFieldName("ProvisionedThroughput");
                ProvisionedThroughputDescriptionJsonMarshaller.getInstance().marshall(tableDescription.getProvisionedThroughput(), jsonGenerator);
            }
            if (tableDescription.getTableSizeBytes() != null) {
                jsonGenerator.writeFieldName("TableSizeBytes").writeValue(tableDescription.getTableSizeBytes().longValue());
            }
            if (tableDescription.getItemCount() != null) {
                jsonGenerator.writeFieldName("ItemCount").writeValue(tableDescription.getItemCount().longValue());
            }
            if (tableDescription.getTableArn() != null) {
                jsonGenerator.writeFieldName("TableArn").writeValue(tableDescription.getTableArn());
            }
            if ((localSecondaryIndexesList = tableDescription.getLocalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("LocalSecondaryIndexes");
                jsonGenerator.writeStartArray();
                for (LocalSecondaryIndexDescription localSecondaryIndexesListValue : localSecondaryIndexesList) {
                    if (localSecondaryIndexesListValue == null) continue;
                    LocalSecondaryIndexDescriptionJsonMarshaller.getInstance().marshall(localSecondaryIndexesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((globalSecondaryIndexesList = tableDescription.getGlobalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("GlobalSecondaryIndexes");
                jsonGenerator.writeStartArray();
                for (GlobalSecondaryIndexDescription globalSecondaryIndexesListValue : globalSecondaryIndexesList) {
                    if (globalSecondaryIndexesListValue == null) continue;
                    GlobalSecondaryIndexDescriptionJsonMarshaller.getInstance().marshall(globalSecondaryIndexesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (tableDescription.getStreamSpecification() != null) {
                jsonGenerator.writeFieldName("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(tableDescription.getStreamSpecification(), jsonGenerator);
            }
            if (tableDescription.getLatestStreamLabel() != null) {
                jsonGenerator.writeFieldName("LatestStreamLabel").writeValue(tableDescription.getLatestStreamLabel());
            }
            if (tableDescription.getLatestStreamArn() != null) {
                jsonGenerator.writeFieldName("LatestStreamArn").writeValue(tableDescription.getLatestStreamArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TableDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TableDescriptionJsonMarshaller();
        }
        return instance;
    }
}

