/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.NetworkBinding;
import com.amazonaws.util.json.JSONWriter;

public class NetworkBindingJsonMarshaller {
    private static NetworkBindingJsonMarshaller instance;

    public void marshall(NetworkBinding networkBinding, JSONWriter jsonWriter) {
        if (networkBinding == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (networkBinding.getBindIP() != null) {
                jsonWriter.key("bindIP").value((Object)networkBinding.getBindIP());
            }
            if (networkBinding.getContainerPort() != null) {
                jsonWriter.key("containerPort").value((Object)networkBinding.getContainerPort());
            }
            if (networkBinding.getHostPort() != null) {
                jsonWriter.key("hostPort").value((Object)networkBinding.getHostPort());
            }
            if (networkBinding.getProtocol() != null) {
                jsonWriter.key("protocol").value((Object)networkBinding.getProtocol());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NetworkBindingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkBindingJsonMarshaller();
        }
        return instance;
    }
}

