/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.inspector.AmazonInspectorAsync;
import com.amazonaws.services.inspector.AmazonInspectorClient;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsResult;
import com.amazonaws.services.inspector.model.AttachAssessmentAndRulesPackageRequest;
import com.amazonaws.services.inspector.model.AttachAssessmentAndRulesPackageResult;
import com.amazonaws.services.inspector.model.CreateApplicationRequest;
import com.amazonaws.services.inspector.model.CreateApplicationResult;
import com.amazonaws.services.inspector.model.CreateAssessmentRequest;
import com.amazonaws.services.inspector.model.CreateAssessmentResult;
import com.amazonaws.services.inspector.model.CreateResourceGroupRequest;
import com.amazonaws.services.inspector.model.CreateResourceGroupResult;
import com.amazonaws.services.inspector.model.DeleteApplicationRequest;
import com.amazonaws.services.inspector.model.DeleteApplicationResult;
import com.amazonaws.services.inspector.model.DeleteAssessmentRequest;
import com.amazonaws.services.inspector.model.DeleteAssessmentResult;
import com.amazonaws.services.inspector.model.DeleteRunRequest;
import com.amazonaws.services.inspector.model.DeleteRunResult;
import com.amazonaws.services.inspector.model.DescribeApplicationRequest;
import com.amazonaws.services.inspector.model.DescribeApplicationResult;
import com.amazonaws.services.inspector.model.DescribeAssessmentRequest;
import com.amazonaws.services.inspector.model.DescribeAssessmentResult;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.DescribeCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.DescribeFindingRequest;
import com.amazonaws.services.inspector.model.DescribeFindingResult;
import com.amazonaws.services.inspector.model.DescribeResourceGroupRequest;
import com.amazonaws.services.inspector.model.DescribeResourceGroupResult;
import com.amazonaws.services.inspector.model.DescribeRulesPackageRequest;
import com.amazonaws.services.inspector.model.DescribeRulesPackageResult;
import com.amazonaws.services.inspector.model.DescribeRunRequest;
import com.amazonaws.services.inspector.model.DescribeRunResult;
import com.amazonaws.services.inspector.model.DetachAssessmentAndRulesPackageRequest;
import com.amazonaws.services.inspector.model.DetachAssessmentAndRulesPackageResult;
import com.amazonaws.services.inspector.model.GetAssessmentTelemetryRequest;
import com.amazonaws.services.inspector.model.GetAssessmentTelemetryResult;
import com.amazonaws.services.inspector.model.ListApplicationsRequest;
import com.amazonaws.services.inspector.model.ListApplicationsResult;
import com.amazonaws.services.inspector.model.ListAssessmentAgentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentAgentsResult;
import com.amazonaws.services.inspector.model.ListAssessmentsRequest;
import com.amazonaws.services.inspector.model.ListAssessmentsResult;
import com.amazonaws.services.inspector.model.ListAttachedAssessmentsRequest;
import com.amazonaws.services.inspector.model.ListAttachedAssessmentsResult;
import com.amazonaws.services.inspector.model.ListAttachedRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListAttachedRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.ListFindingsResult;
import com.amazonaws.services.inspector.model.ListRulesPackagesRequest;
import com.amazonaws.services.inspector.model.ListRulesPackagesResult;
import com.amazonaws.services.inspector.model.ListRunsRequest;
import com.amazonaws.services.inspector.model.ListRunsResult;
import com.amazonaws.services.inspector.model.ListTagsForResourceRequest;
import com.amazonaws.services.inspector.model.ListTagsForResourceResult;
import com.amazonaws.services.inspector.model.LocalizeTextRequest;
import com.amazonaws.services.inspector.model.LocalizeTextResult;
import com.amazonaws.services.inspector.model.PreviewAgentsForResourceGroupRequest;
import com.amazonaws.services.inspector.model.PreviewAgentsForResourceGroupResult;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import com.amazonaws.services.inspector.model.RegisterCrossAccountAccessRoleResult;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsResult;
import com.amazonaws.services.inspector.model.RunAssessmentRequest;
import com.amazonaws.services.inspector.model.RunAssessmentResult;
import com.amazonaws.services.inspector.model.SetTagsForResourceRequest;
import com.amazonaws.services.inspector.model.SetTagsForResourceResult;
import com.amazonaws.services.inspector.model.StartDataCollectionRequest;
import com.amazonaws.services.inspector.model.StartDataCollectionResult;
import com.amazonaws.services.inspector.model.StopDataCollectionRequest;
import com.amazonaws.services.inspector.model.StopDataCollectionResult;
import com.amazonaws.services.inspector.model.UpdateApplicationRequest;
import com.amazonaws.services.inspector.model.UpdateApplicationResult;
import com.amazonaws.services.inspector.model.UpdateAssessmentRequest;
import com.amazonaws.services.inspector.model.UpdateAssessmentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonInspectorAsyncClient
extends AmazonInspectorClient
implements AmazonInspectorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonInspectorAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonInspectorAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonInspectorAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonInspectorAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonInspectorAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonInspectorAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddAttributesToFindingsResult> addAttributesToFindingsAsync(AddAttributesToFindingsRequest request) {
        return this.addAttributesToFindingsAsync(request, null);
    }

    @Override
    public Future<AddAttributesToFindingsResult> addAttributesToFindingsAsync(final AddAttributesToFindingsRequest request, final AsyncHandler<AddAttributesToFindingsRequest, AddAttributesToFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddAttributesToFindingsResult>(){

            @Override
            public AddAttributesToFindingsResult call() throws Exception {
                AddAttributesToFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.addAttributesToFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachAssessmentAndRulesPackageResult> attachAssessmentAndRulesPackageAsync(AttachAssessmentAndRulesPackageRequest request) {
        return this.attachAssessmentAndRulesPackageAsync(request, null);
    }

    @Override
    public Future<AttachAssessmentAndRulesPackageResult> attachAssessmentAndRulesPackageAsync(final AttachAssessmentAndRulesPackageRequest request, final AsyncHandler<AttachAssessmentAndRulesPackageRequest, AttachAssessmentAndRulesPackageResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachAssessmentAndRulesPackageResult>(){

            @Override
            public AttachAssessmentAndRulesPackageResult call() throws Exception {
                AttachAssessmentAndRulesPackageResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.attachAssessmentAndRulesPackage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(final CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.createApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssessmentResult> createAssessmentAsync(CreateAssessmentRequest request) {
        return this.createAssessmentAsync(request, null);
    }

    @Override
    public Future<CreateAssessmentResult> createAssessmentAsync(final CreateAssessmentRequest request, final AsyncHandler<CreateAssessmentRequest, CreateAssessmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAssessmentResult>(){

            @Override
            public CreateAssessmentResult call() throws Exception {
                CreateAssessmentResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.createAssessment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateResourceGroupResult> createResourceGroupAsync(CreateResourceGroupRequest request) {
        return this.createResourceGroupAsync(request, null);
    }

    @Override
    public Future<CreateResourceGroupResult> createResourceGroupAsync(final CreateResourceGroupRequest request, final AsyncHandler<CreateResourceGroupRequest, CreateResourceGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateResourceGroupResult>(){

            @Override
            public CreateResourceGroupResult call() throws Exception {
                CreateResourceGroupResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.createResourceGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(final DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.deleteApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssessmentResult> deleteAssessmentAsync(DeleteAssessmentRequest request) {
        return this.deleteAssessmentAsync(request, null);
    }

    @Override
    public Future<DeleteAssessmentResult> deleteAssessmentAsync(final DeleteAssessmentRequest request, final AsyncHandler<DeleteAssessmentRequest, DeleteAssessmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteAssessmentResult>(){

            @Override
            public DeleteAssessmentResult call() throws Exception {
                DeleteAssessmentResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.deleteAssessment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRunResult> deleteRunAsync(DeleteRunRequest request) {
        return this.deleteRunAsync(request, null);
    }

    @Override
    public Future<DeleteRunResult> deleteRunAsync(final DeleteRunRequest request, final AsyncHandler<DeleteRunRequest, DeleteRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRunResult>(){

            @Override
            public DeleteRunResult call() throws Exception {
                DeleteRunResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.deleteRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(DescribeApplicationRequest request) {
        return this.describeApplicationAsync(request, null);
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(final DescribeApplicationRequest request, final AsyncHandler<DescribeApplicationRequest, DescribeApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeApplicationResult>(){

            @Override
            public DescribeApplicationResult call() throws Exception {
                DescribeApplicationResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssessmentResult> describeAssessmentAsync(DescribeAssessmentRequest request) {
        return this.describeAssessmentAsync(request, null);
    }

    @Override
    public Future<DescribeAssessmentResult> describeAssessmentAsync(final DescribeAssessmentRequest request, final AsyncHandler<DescribeAssessmentRequest, DescribeAssessmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAssessmentResult>(){

            @Override
            public DescribeAssessmentResult call() throws Exception {
                DescribeAssessmentResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeAssessment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCrossAccountAccessRoleResult> describeCrossAccountAccessRoleAsync(DescribeCrossAccountAccessRoleRequest request) {
        return this.describeCrossAccountAccessRoleAsync(request, null);
    }

    @Override
    public Future<DescribeCrossAccountAccessRoleResult> describeCrossAccountAccessRoleAsync(final DescribeCrossAccountAccessRoleRequest request, final AsyncHandler<DescribeCrossAccountAccessRoleRequest, DescribeCrossAccountAccessRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCrossAccountAccessRoleResult>(){

            @Override
            public DescribeCrossAccountAccessRoleResult call() throws Exception {
                DescribeCrossAccountAccessRoleResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeCrossAccountAccessRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFindingResult> describeFindingAsync(DescribeFindingRequest request) {
        return this.describeFindingAsync(request, null);
    }

    @Override
    public Future<DescribeFindingResult> describeFindingAsync(final DescribeFindingRequest request, final AsyncHandler<DescribeFindingRequest, DescribeFindingResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFindingResult>(){

            @Override
            public DescribeFindingResult call() throws Exception {
                DescribeFindingResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeFinding(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourceGroupResult> describeResourceGroupAsync(DescribeResourceGroupRequest request) {
        return this.describeResourceGroupAsync(request, null);
    }

    @Override
    public Future<DescribeResourceGroupResult> describeResourceGroupAsync(final DescribeResourceGroupRequest request, final AsyncHandler<DescribeResourceGroupRequest, DescribeResourceGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeResourceGroupResult>(){

            @Override
            public DescribeResourceGroupResult call() throws Exception {
                DescribeResourceGroupResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeResourceGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRulesPackageResult> describeRulesPackageAsync(DescribeRulesPackageRequest request) {
        return this.describeRulesPackageAsync(request, null);
    }

    @Override
    public Future<DescribeRulesPackageResult> describeRulesPackageAsync(final DescribeRulesPackageRequest request, final AsyncHandler<DescribeRulesPackageRequest, DescribeRulesPackageResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRulesPackageResult>(){

            @Override
            public DescribeRulesPackageResult call() throws Exception {
                DescribeRulesPackageResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeRulesPackage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRunResult> describeRunAsync(DescribeRunRequest request) {
        return this.describeRunAsync(request, null);
    }

    @Override
    public Future<DescribeRunResult> describeRunAsync(final DescribeRunRequest request, final AsyncHandler<DescribeRunRequest, DescribeRunResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRunResult>(){

            @Override
            public DescribeRunResult call() throws Exception {
                DescribeRunResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.describeRun(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachAssessmentAndRulesPackageResult> detachAssessmentAndRulesPackageAsync(DetachAssessmentAndRulesPackageRequest request) {
        return this.detachAssessmentAndRulesPackageAsync(request, null);
    }

    @Override
    public Future<DetachAssessmentAndRulesPackageResult> detachAssessmentAndRulesPackageAsync(final DetachAssessmentAndRulesPackageRequest request, final AsyncHandler<DetachAssessmentAndRulesPackageRequest, DetachAssessmentAndRulesPackageResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachAssessmentAndRulesPackageResult>(){

            @Override
            public DetachAssessmentAndRulesPackageResult call() throws Exception {
                DetachAssessmentAndRulesPackageResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.detachAssessmentAndRulesPackage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAssessmentTelemetryResult> getAssessmentTelemetryAsync(GetAssessmentTelemetryRequest request) {
        return this.getAssessmentTelemetryAsync(request, null);
    }

    @Override
    public Future<GetAssessmentTelemetryResult> getAssessmentTelemetryAsync(final GetAssessmentTelemetryRequest request, final AsyncHandler<GetAssessmentTelemetryRequest, GetAssessmentTelemetryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAssessmentTelemetryResult>(){

            @Override
            public GetAssessmentTelemetryResult call() throws Exception {
                GetAssessmentTelemetryResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.getAssessmentTelemetry(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(final ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listApplications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssessmentAgentsResult> listAssessmentAgentsAsync(ListAssessmentAgentsRequest request) {
        return this.listAssessmentAgentsAsync(request, null);
    }

    @Override
    public Future<ListAssessmentAgentsResult> listAssessmentAgentsAsync(final ListAssessmentAgentsRequest request, final AsyncHandler<ListAssessmentAgentsRequest, ListAssessmentAgentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssessmentAgentsResult>(){

            @Override
            public ListAssessmentAgentsResult call() throws Exception {
                ListAssessmentAgentsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAssessmentAgents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssessmentsResult> listAssessmentsAsync(ListAssessmentsRequest request) {
        return this.listAssessmentsAsync(request, null);
    }

    @Override
    public Future<ListAssessmentsResult> listAssessmentsAsync(final ListAssessmentsRequest request, final AsyncHandler<ListAssessmentsRequest, ListAssessmentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAssessmentsResult>(){

            @Override
            public ListAssessmentsResult call() throws Exception {
                ListAssessmentsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAssessments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttachedAssessmentsResult> listAttachedAssessmentsAsync(ListAttachedAssessmentsRequest request) {
        return this.listAttachedAssessmentsAsync(request, null);
    }

    @Override
    public Future<ListAttachedAssessmentsResult> listAttachedAssessmentsAsync(final ListAttachedAssessmentsRequest request, final AsyncHandler<ListAttachedAssessmentsRequest, ListAttachedAssessmentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAttachedAssessmentsResult>(){

            @Override
            public ListAttachedAssessmentsResult call() throws Exception {
                ListAttachedAssessmentsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAttachedAssessments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttachedRulesPackagesResult> listAttachedRulesPackagesAsync(ListAttachedRulesPackagesRequest request) {
        return this.listAttachedRulesPackagesAsync(request, null);
    }

    @Override
    public Future<ListAttachedRulesPackagesResult> listAttachedRulesPackagesAsync(final ListAttachedRulesPackagesRequest request, final AsyncHandler<ListAttachedRulesPackagesRequest, ListAttachedRulesPackagesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAttachedRulesPackagesResult>(){

            @Override
            public ListAttachedRulesPackagesResult call() throws Exception {
                ListAttachedRulesPackagesResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listAttachedRulesPackages(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(ListFindingsRequest request) {
        return this.listFindingsAsync(request, null);
    }

    @Override
    public Future<ListFindingsResult> listFindingsAsync(final ListFindingsRequest request, final AsyncHandler<ListFindingsRequest, ListFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFindingsResult>(){

            @Override
            public ListFindingsResult call() throws Exception {
                ListFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesPackagesResult> listRulesPackagesAsync(ListRulesPackagesRequest request) {
        return this.listRulesPackagesAsync(request, null);
    }

    @Override
    public Future<ListRulesPackagesResult> listRulesPackagesAsync(final ListRulesPackagesRequest request, final AsyncHandler<ListRulesPackagesRequest, ListRulesPackagesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRulesPackagesResult>(){

            @Override
            public ListRulesPackagesResult call() throws Exception {
                ListRulesPackagesResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listRulesPackages(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRunsResult> listRunsAsync(ListRunsRequest request) {
        return this.listRunsAsync(request, null);
    }

    @Override
    public Future<ListRunsResult> listRunsAsync(final ListRunsRequest request, final AsyncHandler<ListRunsRequest, ListRunsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRunsResult>(){

            @Override
            public ListRunsResult call() throws Exception {
                ListRunsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listRuns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LocalizeTextResult> localizeTextAsync(LocalizeTextRequest request) {
        return this.localizeTextAsync(request, null);
    }

    @Override
    public Future<LocalizeTextResult> localizeTextAsync(final LocalizeTextRequest request, final AsyncHandler<LocalizeTextRequest, LocalizeTextResult> asyncHandler) {
        return this.executorService.submit(new Callable<LocalizeTextResult>(){

            @Override
            public LocalizeTextResult call() throws Exception {
                LocalizeTextResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.localizeText(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PreviewAgentsForResourceGroupResult> previewAgentsForResourceGroupAsync(PreviewAgentsForResourceGroupRequest request) {
        return this.previewAgentsForResourceGroupAsync(request, null);
    }

    @Override
    public Future<PreviewAgentsForResourceGroupResult> previewAgentsForResourceGroupAsync(final PreviewAgentsForResourceGroupRequest request, final AsyncHandler<PreviewAgentsForResourceGroupRequest, PreviewAgentsForResourceGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<PreviewAgentsForResourceGroupResult>(){

            @Override
            public PreviewAgentsForResourceGroupResult call() throws Exception {
                PreviewAgentsForResourceGroupResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.previewAgentsForResourceGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterCrossAccountAccessRoleResult> registerCrossAccountAccessRoleAsync(RegisterCrossAccountAccessRoleRequest request) {
        return this.registerCrossAccountAccessRoleAsync(request, null);
    }

    @Override
    public Future<RegisterCrossAccountAccessRoleResult> registerCrossAccountAccessRoleAsync(final RegisterCrossAccountAccessRoleRequest request, final AsyncHandler<RegisterCrossAccountAccessRoleRequest, RegisterCrossAccountAccessRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<RegisterCrossAccountAccessRoleResult>(){

            @Override
            public RegisterCrossAccountAccessRoleResult call() throws Exception {
                RegisterCrossAccountAccessRoleResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.registerCrossAccountAccessRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveAttributesFromFindingsResult> removeAttributesFromFindingsAsync(RemoveAttributesFromFindingsRequest request) {
        return this.removeAttributesFromFindingsAsync(request, null);
    }

    @Override
    public Future<RemoveAttributesFromFindingsResult> removeAttributesFromFindingsAsync(final RemoveAttributesFromFindingsRequest request, final AsyncHandler<RemoveAttributesFromFindingsRequest, RemoveAttributesFromFindingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveAttributesFromFindingsResult>(){

            @Override
            public RemoveAttributesFromFindingsResult call() throws Exception {
                RemoveAttributesFromFindingsResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.removeAttributesFromFindings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RunAssessmentResult> runAssessmentAsync(RunAssessmentRequest request) {
        return this.runAssessmentAsync(request, null);
    }

    @Override
    public Future<RunAssessmentResult> runAssessmentAsync(final RunAssessmentRequest request, final AsyncHandler<RunAssessmentRequest, RunAssessmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<RunAssessmentResult>(){

            @Override
            public RunAssessmentResult call() throws Exception {
                RunAssessmentResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.runAssessment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetTagsForResourceResult> setTagsForResourceAsync(SetTagsForResourceRequest request) {
        return this.setTagsForResourceAsync(request, null);
    }

    @Override
    public Future<SetTagsForResourceResult> setTagsForResourceAsync(final SetTagsForResourceRequest request, final AsyncHandler<SetTagsForResourceRequest, SetTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetTagsForResourceResult>(){

            @Override
            public SetTagsForResourceResult call() throws Exception {
                SetTagsForResourceResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.setTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDataCollectionResult> startDataCollectionAsync(StartDataCollectionRequest request) {
        return this.startDataCollectionAsync(request, null);
    }

    @Override
    public Future<StartDataCollectionResult> startDataCollectionAsync(final StartDataCollectionRequest request, final AsyncHandler<StartDataCollectionRequest, StartDataCollectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartDataCollectionResult>(){

            @Override
            public StartDataCollectionResult call() throws Exception {
                StartDataCollectionResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.startDataCollection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopDataCollectionResult> stopDataCollectionAsync(StopDataCollectionRequest request) {
        return this.stopDataCollectionAsync(request, null);
    }

    @Override
    public Future<StopDataCollectionResult> stopDataCollectionAsync(final StopDataCollectionRequest request, final AsyncHandler<StopDataCollectionRequest, StopDataCollectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopDataCollectionResult>(){

            @Override
            public StopDataCollectionResult call() throws Exception {
                StopDataCollectionResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.stopDataCollection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(final UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.updateApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAssessmentResult> updateAssessmentAsync(UpdateAssessmentRequest request) {
        return this.updateAssessmentAsync(request, null);
    }

    @Override
    public Future<UpdateAssessmentResult> updateAssessmentAsync(final UpdateAssessmentRequest request, final AsyncHandler<UpdateAssessmentRequest, UpdateAssessmentResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateAssessmentResult>(){

            @Override
            public UpdateAssessmentResult call() throws Exception {
                UpdateAssessmentResult result;
                try {
                    result = AmazonInspectorAsyncClient.this.updateAssessment(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

