/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kms.model.KeyMetadata;
import com.amazonaws.util.json.SdkJsonGenerator;

public class KeyMetadataJsonMarshaller {
    private static KeyMetadataJsonMarshaller instance;

    public void marshall(KeyMetadata keyMetadata, SdkJsonGenerator jsonGenerator) {
        if (keyMetadata == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyMetadata.getAWSAccountId() != null) {
                jsonGenerator.writeFieldName("AWSAccountId").writeValue(keyMetadata.getAWSAccountId());
            }
            if (keyMetadata.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(keyMetadata.getKeyId());
            }
            if (keyMetadata.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(keyMetadata.getArn());
            }
            if (keyMetadata.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(keyMetadata.getCreationDate());
            }
            if (keyMetadata.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(keyMetadata.getEnabled().booleanValue());
            }
            if (keyMetadata.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(keyMetadata.getDescription());
            }
            if (keyMetadata.getKeyUsage() != null) {
                jsonGenerator.writeFieldName("KeyUsage").writeValue(keyMetadata.getKeyUsage());
            }
            if (keyMetadata.getKeyState() != null) {
                jsonGenerator.writeFieldName("KeyState").writeValue(keyMetadata.getKeyState());
            }
            if (keyMetadata.getDeletionDate() != null) {
                jsonGenerator.writeFieldName("DeletionDate").writeValue(keyMetadata.getDeletionDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyMetadataJsonMarshaller();
        }
        return instance;
    }
}

