/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class ReEncryptRequestMarshaller
implements Marshaller<Request<ReEncryptRequest>, ReEncryptRequest> {
    public Request<ReEncryptRequest> marshall(ReEncryptRequest reEncryptRequest) {
        if (reEncryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reEncryptRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ReEncrypt");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap destinationEncryptionContextMap;
            SdkInternalMap sourceEncryptionContextMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (reEncryptRequest.getCiphertextBlob() != null) {
                jsonGenerator.writeFieldName("CiphertextBlob").writeValue(reEncryptRequest.getCiphertextBlob());
            }
            if (!(sourceEncryptionContextMap = (SdkInternalMap)reEncryptRequest.getSourceEncryptionContext()).isEmpty() || !sourceEncryptionContextMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SourceEncryptionContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry sourceEncryptionContextMapValue : sourceEncryptionContextMap.entrySet()) {
                    if (sourceEncryptionContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)sourceEncryptionContextMapValue.getKey());
                    jsonGenerator.writeValue((String)sourceEncryptionContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (reEncryptRequest.getDestinationKeyId() != null) {
                jsonGenerator.writeFieldName("DestinationKeyId").writeValue(reEncryptRequest.getDestinationKeyId());
            }
            if (!(destinationEncryptionContextMap = (SdkInternalMap)reEncryptRequest.getDestinationEncryptionContext()).isEmpty() || !destinationEncryptionContextMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DestinationEncryptionContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry destinationEncryptionContextMapValue : destinationEncryptionContextMap.entrySet()) {
                    if (destinationEncryptionContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)destinationEncryptionContextMapValue.getKey());
                    jsonGenerator.writeValue((String)destinationEncryptionContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(grantTokensList = (SdkInternalList)reEncryptRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GrantTokens");
                jsonGenerator.writeStartArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonGenerator.writeValue(grantTokensListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

