/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest;
import com.amazonaws.services.simpleemail.model.ReceiptFilter;
import com.amazonaws.services.simpleemail.model.ReceiptIpFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateReceiptFilterRequestMarshaller
implements Marshaller<Request<CreateReceiptFilterRequest>, CreateReceiptFilterRequest> {
    public Request<CreateReceiptFilterRequest> marshall(CreateReceiptFilterRequest createReceiptFilterRequest) {
        if (createReceiptFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReceiptFilterRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateReceiptFilter");
        request.addParameter("Version", "2010-12-01");
        ReceiptFilter receiptFilterFilter = createReceiptFilterRequest.getFilter();
        if (receiptFilterFilter != null) {
            ReceiptIpFilter receiptIpFilterIpFilter;
            if (receiptFilterFilter.getName() != null) {
                request.addParameter("Filter.Name", StringUtils.fromString((String)receiptFilterFilter.getName()));
            }
            if ((receiptIpFilterIpFilter = receiptFilterFilter.getIpFilter()) != null) {
                if (receiptIpFilterIpFilter.getPolicy() != null) {
                    request.addParameter("Filter.IpFilter.Policy", StringUtils.fromString((String)receiptIpFilterIpFilter.getPolicy()));
                }
                if (receiptIpFilterIpFilter.getCidr() != null) {
                    request.addParameter("Filter.IpFilter.Cidr", StringUtils.fromString((String)receiptIpFilterIpFilter.getCidr()));
                }
            }
        }
        return request;
    }
}

