/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIdentityPoliciesRequestMarshaller
implements Marshaller<Request<GetIdentityPoliciesRequest>, GetIdentityPoliciesRequest> {
    public Request<GetIdentityPoliciesRequest> marshall(GetIdentityPoliciesRequest getIdentityPoliciesRequest) {
        SdkInternalList policyNamesList;
        if (getIdentityPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIdentityPoliciesRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "GetIdentityPolicies");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityPoliciesRequest.getIdentity() != null) {
            request.addParameter("Identity", StringUtils.fromString((String)getIdentityPoliciesRequest.getIdentity()));
        }
        if (!(policyNamesList = (SdkInternalList)getIdentityPoliciesRequest.getPolicyNames()).isEmpty() || !policyNamesList.isAutoConstruct()) {
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringUtils.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        return request;
    }
}

