/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.HealthCheckConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateHealthCheckRequestMarshaller
implements Marshaller<Request<CreateHealthCheckRequest>, CreateHealthCheckRequest> {
    @Override
    public Request<CreateHealthCheckRequest> marshall(CreateHealthCheckRequest createHealthCheckRequest) {
        HealthCheckConfig healthCheckConfigHealthCheckConfig;
        if (createHealthCheckRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHealthCheckRequest> request = new DefaultRequest<CreateHealthCheckRequest>(createHealthCheckRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/healthcheck";
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("CreateHealthCheckRequest");
        if (createHealthCheckRequest.getCallerReference() != null) {
            xmlWriter.startElement("CallerReference").value(createHealthCheckRequest.getCallerReference()).endElement();
        }
        if (createHealthCheckRequest != null && (healthCheckConfigHealthCheckConfig = createHealthCheckRequest.getHealthCheckConfig()) != null) {
            xmlWriter.startElement("HealthCheckConfig");
            if (healthCheckConfigHealthCheckConfig.getIPAddress() != null) {
                xmlWriter.startElement("IPAddress").value(healthCheckConfigHealthCheckConfig.getIPAddress()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getPort() != null) {
                xmlWriter.startElement("Port").value(healthCheckConfigHealthCheckConfig.getPort()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getType() != null) {
                xmlWriter.startElement("Type").value(healthCheckConfigHealthCheckConfig.getType()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getResourcePath() != null) {
                xmlWriter.startElement("ResourcePath").value(healthCheckConfigHealthCheckConfig.getResourcePath()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getFullyQualifiedDomainName() != null) {
                xmlWriter.startElement("FullyQualifiedDomainName").value(healthCheckConfigHealthCheckConfig.getFullyQualifiedDomainName()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getSearchString() != null) {
                xmlWriter.startElement("SearchString").value(healthCheckConfigHealthCheckConfig.getSearchString()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getRequestInterval() != null) {
                xmlWriter.startElement("RequestInterval").value(healthCheckConfigHealthCheckConfig.getRequestInterval()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getFailureThreshold() != null) {
                xmlWriter.startElement("FailureThreshold").value(healthCheckConfigHealthCheckConfig.getFailureThreshold()).endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes("UTF-8").length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

