/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ByteIntAssociativeContainer;
import com.carrotsearch.hppc.ByteIntMap;
import com.carrotsearch.hppc.ByteLookupContainer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ByteIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.ByteIntProcedure;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ByteIntOpenHashMap
implements ByteIntMap,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public byte[] keys;
    public int[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public ByteIntOpenHashMap() {
        this(16);
    }

    public ByteIntOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteIntOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ByteIntOpenHashMap(ByteIntAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public int put(byte key, int value) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        this.values[slot] = value;
        return 0;
    }

    @Override
    public final int putAll(ByteIntAssociativeContainer container) {
        int count = this.assigned;
        for (ByteIntCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public final int putAll(Iterable<? extends ByteIntCursor> iterable) {
        int count = this.assigned;
        for (ByteIntCursor byteIntCursor : iterable) {
            this.put(byteIntCursor.key, byteIntCursor.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(byte key, int value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final int putOrAdd(byte key, int putValue, int additionValue) {
        if (this.assigned >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                int n = slot;
                int n2 = this.values[n] + additionValue;
                this.values[n] = n2;
                return n2;
            }
            slot = slot + 1 & mask;
        }
        ++this.assigned;
        this.allocated[slot] = true;
        this.keys[slot] = key;
        int v = this.values[slot] = putValue;
        return v;
    }

    private void expandAndRehash() {
        byte[] oldKeys = this.keys;
        int[] oldValues = this.values;
        boolean[] oldStates = this.allocated;
        assert (this.assigned >= this.resizeThreshold);
        this.allocateBuffers(this.nextCapacity(this.keys.length));
        int mask = this.allocated.length - 1;
        for (int i = 0; i < oldStates.length; ++i) {
            if (!oldStates[i]) continue;
            byte key = oldKeys[i];
            int value = oldValues[i];
            int slot = Internals.rehash(key) & mask;
            while (this.allocated[slot] && key != this.keys[slot]) {
                slot = slot + 1 & mask;
            }
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = new byte[capacity];
        this.values = new int[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public int remove(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                int v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    protected final void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr]) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public final int removeAll(ByteContainer container) {
        int before = this.assigned;
        for (ByteCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public final int removeAll(BytePredicate predicate) {
        int before = this.assigned;
        byte[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public int get(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public int lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public int lset(int key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        int previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(byte key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ByteIntCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ByteIntMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ByteIntMap && (other = (ByteIntMap)obj).size() == this.size()) {
                for (ByteIntCursor c : this) {
                    int v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ByteIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ByteIntProcedure> T forEach(T procedure) {
        byte[] keys = this.keys;
        int[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        return new ValuesContainer();
    }

    public ByteIntOpenHashMap clone() {
        try {
            ByteIntOpenHashMap cloned = (ByteIntOpenHashMap)super.clone();
            cloned.keys = (byte[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static ByteIntOpenHashMap from(byte[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteIntOpenHashMap map = new ByteIntOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static ByteIntOpenHashMap from(ByteIntAssociativeContainer container) {
        return new ByteIntOpenHashMap(container);
    }

    public static ByteIntOpenHashMap newInstance() {
        return new ByteIntOpenHashMap();
    }

    public static ByteIntOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new ByteIntOpenHashMap(initialCapacity, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max = ByteIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ByteIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ByteIntOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ByteIntOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            boolean[] allocated = ByteIntOpenHashMap.this.allocated;
            int[] values = ByteIntOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            boolean[] allocated = ByteIntOpenHashMap.this.allocated;
            int[] values = ByteIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            boolean[] allocated = ByteIntOpenHashMap.this.allocated;
            int[] values = ByteIntOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            int max = ByteIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ByteIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteIntOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteIntOpenHashMap owner;

        public KeysContainer() {
            this.owner = ByteIntOpenHashMap.this;
        }

        @Override
        public boolean contains(byte e) {
            return ByteIntOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            byte[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            byte[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ByteIntCursor> {
        private final ByteIntCursor cursor = new ByteIntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteIntCursor fetch() {
            int i;
            int max = ByteIntOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !ByteIntOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteIntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ByteIntOpenHashMap.this.keys[i];
            this.cursor.value = ByteIntOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

