/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.cursors.IntCursor;

public class IntStack
extends IntArrayList {
    public IntStack() {
    }

    public IntStack(int initialCapacity) {
        super(initialCapacity);
    }

    public IntStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public IntStack(IntContainer container) {
        super(container);
    }

    public final void push(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(int e1, int e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(int e1, int e2, int e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(int e1, int e2, int e3, int e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(int[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(int ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(IntContainer container) {
        return this.addAll(container);
    }

    public final int pushAll(Iterable<? extends IntCursor> iterable) {
        return this.addAll(iterable);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public final int pop() {
        assert (this.elementsCount > 0);
        int v = this.buffer[--this.elementsCount];
        return v;
    }

    public final int peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static IntStack newInstance() {
        return new IntStack();
    }

    public static IntStack newInstanceWithCapacity(int initialCapacity) {
        return new IntStack(initialCapacity);
    }

    public static IntStack from(int ... elements) {
        IntStack stack = new IntStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static IntStack from(IntContainer container) {
        return new IntStack(container);
    }

    @Override
    public IntStack clone() {
        return (IntStack)super.clone();
    }
}

